% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_postprocessing.R
\name{addPitchCands}
\alias{addPitchCands}
\title{Plot pitch candidates}
\usage{
addPitchCands(
  pitchCands,
  pitchCert,
  pitchSource,
  pitch,
  timestamps = NULL,
  candPlot = list(),
  pitchPlot = list(),
  extraContour = NULL,
  extraContour_pars = list(),
  priorMean = NULL,
  priorSD = NULL,
  pitchFloor = NULL,
  pitchCeiling = NULL,
  addToExistingPlot = TRUE,
  showLegend = TRUE,
  y_Hz = FALSE,
  yScale = c("orig", "bark", "mel")[1],
  ...
)
}
\arguments{
\item{pitchCands, pitchCert, pitchSource}{matrices of pitch candidates, their
certainty, and pitch tracking method used as generated internally by
analyze(); columns = STFT frames, rows = candidates}

\item{pitch}{best guess at pitch contour; length = ncol(pitchCands)}

\item{candPlot, pitchPlot}{lists of graphical settings for plotting candidates
and pitch contour, respectively}

\item{extraContour}{another contour to add to the plot, such as harmHeight, Hz}

\item{addToExistingPlot}{if TRUE, assumes that a spectrogram is already
plotted; if FALSE, sets up a new plot}

\item{showLegend}{if TRUE, shows a legend}

\item{y_Hz}{if TRUE, plot in Hz, otherwise in kHz}

\item{...}{other graphical parameters used for creating a new plot if
addToExistingPlot = FALSE}
}
\description{
Internal soundgen function.
}
\details{
Plots pitch candidates or adds them to a spectrogram.
}
\examples{
s = soundgen()
a = soundgen:::.analyze(soundgen:::readAudio(s, samplingRate = 16000),
 windowLength = 25, step = 25,
 returnPitchCands = TRUE, plot = FALSE)
spectrogram(s, 16000, windowLength = 25, step = 5, ylim = c(0, 1), osc = FALSE)
soundgen:::addPitchCands(
  pitchCands = a$pitchCands$freq,
  pitchCert = a$pitchCands$cert,
  pitchSource = a$pitchCands$source,
  pitch = a$result$pitch,
  timestamps = a$result$time / 1000)
}
\keyword{internal}
