% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{.resample}
\alias{.resample}
\title{Resample per sound}
\usage{
.resample(
  audio,
  mult = NULL,
  len = NULL,
  samplingRate_new = NULL,
  lowPass = TRUE,
  na.rm = FALSE,
  nPoints = 1,
  plot = FALSE,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{mult}{multiplier of sampling rate: new sampling rate = old sampling
rate x mult, so 1 = no effect, >1 = upsample, <1 = downsample}

\item{len}{if specified, overrides mult and samplingRate_new and simply
returns a vector of length \code{len}}

\item{samplingRate_new}{an alternative to \code{mult} provided that the old
\code{samplingRate is know} (NB: \code{mult} takes precedence)}

\item{lowPass}{if TRUE, applies a low-pass filter before decimating or after
upsampling to avoid aliasing}

\item{na.rm}{if TRUE, NAs are interpolated, otherwise they are preserved in
the output}

\item{nPoints}{the number of points to use for interpolating leading and
trailing NAs: 1 = constant interpolation, 2 = use the first two non-NAs at
the beginning and the last two non-NAs at the end, etc.}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function
}
\keyword{internal}
