% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{VAR}
\alias{VAR}
\title{Estimate VAR, SVAR, or Proxy-SVAR}
\usage{
VAR(
  data,
  horizon = 10,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL,
  structure = "short",
  instrument = NULL,
  instrumented = NULL
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizon}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}

\item{structure}{string: type of structural identification strategy to use in model analysis (NA, 'short', 'IV', or 'IV-short')}

\item{instrument}{string: name of instrumental variable contained in the data matrix}

\item{instrumented}{string: name of variable to be instrumented in IV and IV-short procedure; default is the first non-date variable in data}
}
\value{
\enumerate{
\item data: data.frame with endogenous variables and 'date' column.
\item model: list with data.frame of model coefficients (in psuedo-companion form), data.frame of coefficient standard errors, integer of lags p, integer of horizons, string of frequency, string of deterministic term type, numeric of log-likelihood
\item forecasts: list of data.frames per horizon; data.frame with column for date (day the forecast was made), forecast.date (the date being forecasted), target (variable forecasted), and forecast
\item residuals: list of data.frames per horizon; data.frame of residuals
\item structure: string denoting which structural identification strategy will be used in analysis  (or NA)
\item instrument: data.frame with 'date' column and 'instrument' column (or NULL)
\item instrumented: string denoting which column will be instrumted in 'IV' and 'IV-short' strategies (or NA)
}
}
\description{
Estimate VAR, SVAR, or Proxy-SVAR
}
\details{
See Sims (1980) for details regarding the baseline vector-autoregression (VAR) model. The VAR may be augmented to become a structural VAR (SVAR) with one of three different structural identification strategies:
\enumerate{
\item short-term impact restrictions via Cholesky decomposition, see Christiano et al (1999) for details \strong{(structure = 'short')}
\item external instrument identification, i.e. a Proxy-SVAR strategy, see Mertens and Ravn (2013) for details \strong{(structure = 'IV')}
\item or a combination of short-term and IV identification via Lunsford (2015) \strong{(structure = 'IV-short')}
}

Note that including structure does not change the estimation of model coefficients or forecasts, but does change impulse response functions, forecast error variance decomposition,
and historical decompositions. Historical decompositions will not be available for models using the 'IV' structure. Additionally note that only one instrument may be used in this
estimation routine.
}
\examples{
\donttest{
 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4)

  # impulse response functions
  var.irf = sovereign::var_irf(var)

  # forecast error variance decomposition
  var.fevd = sovereign::var_fevd(var)

  # historical shock decomposition
  var.hd = sovereign::var_hd(var)
}

}
\references{
\enumerate{
\item Christiano, Lawrence, Martin Eichenbaum, and Charles Evans "\href{https://www.sciencedirect.com/science/article/pii/S1574004899010058}{Monetary policy shocks: What have we learned and to what end?}" Handbook of Macroeconomics, Vol 1, Part A, 1999.
\item Lunsford, Kurt "\href{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=2699452#}{Identifying Structural VARs with a Proxy Variable and a Test for a Weak Proxy}" 2015.
\item Mertens, Karel and Morten Ravn "\href{https://www.aeaweb.org/articles?id=10.1257/aer.103.4.1212}{The Dynamic Effects of Personal and Corporate Income Tax Changes in the United States}" 2013.
\item Sims, Christopher "\href{https://www.jstor.org/stable/1912017}{Macroeconomics and Reality}" 1980.
}
}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=var_hd]{var_hd()}}
}
