% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycle_hire.R
\docType{data}
\name{cycle_hire}
\alias{cycle_hire}
\title{Cycle hire points in London}
\format{FORMAT:
\itemize{
    \item{id} {Id of the hire point}
    \item{name} {Name of the point}
    \item{area} {Area they are in}
    \item{nbikes} {The number of bikes currently parked there}
    \item{nempty} {The number of empty places}
    \item{geometry} {sfc_POINT}
}}
\source{
\url{cyclehireapp.com/cyclehirelive/cyclehire.csv}
}
\usage{
cycle_hire
}
\description{
Points
representing cycle hire points accross London.
}
\examples{
library(sf)
data(cycle_hire)
# or
cycle_hire <- st_read(system.file("shapes/cycle_hire.geojson", package="spData"))

plot(cycle_hire)

\dontrun{
# Download the data
cycle_hire = readr::read_csv("http://cyclehireapp.com/cyclehirelive/cyclehire.csv", 
  col_names = FALSE, skip = TRUE)
cycle_hire = cycle_hire[c_names]
c_names = c("id", "name", "area", "lat", "lon", "nbikes", "nempty")
cycle_hire = st_sf(cycle_hire, st_multipoint(c_names[c("lon", "lat")]))
}
}
\keyword{datasets}
\keyword{sf}
