% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions.R
\name{split_lines_at_vertex}
\alias{split_lines_at_vertex}
\title{Split lines at vertices in a SpatialLinesDataFrame}
\usage{
split_lines_at_vertex(lines, points, nearest_lines_idx, mindist)
}
\arguments{
\item{lines}{The SpatialLinesDataframe to split}

\item{points}{The SpatialPoints to add to as vertex to the lines}

\item{nearest_lines_idx}{For each point, the index of the nearest line}

\item{mindist}{The minimum distance between one point and the extremity of
the line to add the point as a vertex.}
}
\value{
An object of class SpatialLinesDataFrame (package sp)
}
\description{
Split lines (SpatialLines) at their nearest vertices
(SpatialPoints), may fail if the line geometries are self intersecting.
}
\examples{
# reading the data
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
bike_accidents <- rgdal::readOGR(eventsgpkg,layer="bike_accidents", verbose=FALSE)
# aggregating points within a 5 metres radius
bike_accidents$weight <- 1
agg_points <- aggregate_points(bike_accidents, 5)
mtl_network$LineID <- 1:nrow(mtl_network)
# snapping point to lines
snapped_points <- snapPointsToLines2(agg_points,
    mtl_network,
    "LineID"
)
# splitting lines
new_lines <- split_lines_at_vertex(mtl_network, snapped_points,
    snapped_points$nearest_line_id, 1)
}
