% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{posteriorPredict}
\alias{posteriorPredict}
\title{Prediction of latent process at new spatial or temporal locations}
\usage{
posteriorPredict(mod_out, coords_new, covars_new, joint = FALSE, nBinom_new)
}
\arguments{
\item{mod_out}{an object returned by any model fit under fixed
hyperparameters or using predictive stacking, i.e., \code{\link[=spLMexact]{spLMexact()}},
\code{\link[=spLMstack]{spLMstack()}}, \code{\link[=spGLMexact]{spGLMexact()}}, \code{\link[=spGLMstack]{spGLMstack()}}, \code{\link[=stvcGLMexact]{stvcGLMexact()}}, or
\code{\link[=stvcGLMstack]{stvcGLMstack()}}.}

\item{coords_new}{a list of new spatial or spatial-temporal coordinates at
which the latent process, the mean, and the response is to be predicted.}

\item{covars_new}{a list of new covariates at the new spatial or
spatial-temporal coordinates. See examples for the structure of this list.}

\item{joint}{a logical value indicating whether to return the joint posterior
predictive samples of the latent process at the new locations or times.
Defaults to \code{FALSE}.}

\item{nBinom_new}{a vector of the number of trials for each new prediction
location or time. Only required if the model family is \code{"binomial"}. Defaults
to a vector of ones, indicating one trial for each new prediction.}
}
\value{
A modified object with the class name preceeded by the identifier
\code{pp} separated by a \code{.}. For example, if input is of class \code{spLMstack}, then
the output of this prediction function would be \code{pp.spLMstack}. The entry
with the tag \code{samples} is updated and will include samples from the posterior
predictive distribution of the latent process, the mean, and the response at
the new locations or times. An entry with the tag \code{prediction} is added
and contains the new coordinates and covariates, and whether the joint
posterior predictive samples were requested.
}
\description{
A function to sample from the posterior predictive distribution
of the latent spatial or spatial-temporal process.
}
\examples{
set.seed(1234)
# training and test data sizes
n_train <- 100
n_pred <- 10

# Example 1: Spatial linear model
# load and split data into training and prediction sets
data(simGaussian)
dat <- simGaussian
dat_train <- dat[1:n_train, ]
dat_pred <- dat[n_train + 1:n_pred, ]

# fit a spatial linear model using predictive stacking
mod1 <- spLMstack(y ~ x1, data = dat_train,
                  coords = as.matrix(dat_train[, c("s1", "s2")]),
                  cor.fn = "matern",
                  params.list = list(phi = c(1.5, 3, 5), nu = c(0.75, 1.25),
                                     noise_sp_ratio = c(0.5, 1, 2)),
                  n.samples = 1000, loopd.method = "psis",
                  parallel = FALSE, solver = "ECOS", verbose = TRUE)

# prepare new coordinates and covariates for prediction
sp_pred <- as.matrix(dat_pred[, c("s1", "s2")])
X_new <- as.matrix(cbind(rep(1, n_pred), dat_pred$x1))

# carry out posterior prediction
mod.pred <- posteriorPredict(mod1, coords_new = sp_pred, covars_new = X_new,
                             joint = TRUE)

# sample from the stacked posterior and posterior predictive distribution
post_samps <- stackedSampler(mod.pred)

# analyze posterior samples
postpred_z <- post_samps$z.pred
post_z_summ <- t(apply(postpred_z, 1, function(x) quantile(x, c(0.025, 0.5, 0.975))))
z_combn <- data.frame(z = dat_pred$z_true, zL = post_z_summ[, 1],
                      zM = post_z_summ[, 2], zU = post_z_summ[, 3])
library(ggplot2)
ggplot(data = z_combn, aes(x = z)) +
  geom_errorbar(aes(ymin = zL, ymax = zU), width = 0.05, alpha = 0.15, color = "skyblue") +
  geom_point(aes(y = zM), size = 0.25, color = "darkblue", alpha = 0.5) +
  geom_abline(slope = 1, intercept = 0, color = "red", linetype = "solid") +
  xlab("True z1") + ylab("Posterior of z1") + theme_bw() +
  theme(panel.background = element_blank(), aspect.ratio = 1)
}
\seealso{
\code{\link[=spLMexact]{spLMexact()}}, \code{\link[=spLMstack]{spLMstack()}}, \code{\link[=spGLMexact]{spGLMexact()}}, \code{\link[=spGLMstack]{spGLMstack()}},
\code{\link[=stvcGLMexact]{stvcGLMexact()}}, \code{\link[=stvcGLMstack]{stvcGLMstack()}}
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
