\name{spacodi.by.nodes}

\alias{spacodi.by.nodes}

\title{conducting randomization tests of turnover in diversity through time}

\description{\code{spacodi.by.nodes} is a function for testing the null expectation of uniform diversity turnover across nodes of a phylogeny.}

\usage{spacodi.by.nodes(sp.plot, phy, sp.parm = "Bst", obs.only = FALSE, return.all = TRUE, n.rep = 10, method = "1s", parm = NULL, dmat = NULL, rand.test = TRUE, r.rep = 10000, ...)}

\arguments{
  \item{sp.plot}{a community dataset in \pkg{spacodiR} format (see \code{\link{as.spacodi}})}
  \item{phy}{a phylogenetic tree of class \code{phylo}; see \code{\link[ape]{read.tree}}}
  \item{sp.parm}{a parameter of interest (one of \code{"Ist","Pst","Bst","PIst"} or analogs for trait data); see \strong{Details}}
  \item{obs.only}{Boolean; whether only estimated \code{sp.parms}s for the empirical data are returned}
  \item{return.all}{Boolean; whether results for all nodes are returned for the empirical data (regardless NA estimates)}
  \item{n.rep}{number of permutations to perform on the dataset}
  \item{method}{reshuffling or simulation procedure to perform (see \strong{Details} for optional methods)}
  \item{parm}{additional parameters, required for methods \code{"1a", "2x", and "3x"} (see \strong{Details})}
  \item{dmat}{an optional matrix of spatial distances between plots, for use only with method \code{"3t"}}
  \item{rand.test}{Boolean; whether a randomization test of observed and expected \code{sp.parm}s is performed}
  \item{r.rep}{number of randomization iterations to perform}
  \item{...}{additional settings to be set for functions called by \code{spacodi.matrices}}
}

\details{
  \code{spacodi.by.nodes} is a function to conduct randomization tests on estimated and observed \code{sp.parms}s through time. See \code{\link{spacodi.calc}} 
  for further information on the possible estimators to use, whether considering phylogenetic or trait diversity.   

    
  \code{spacodi.by.nodes} computes measures of community structure for nodes of 
  a phylogeny that subtend greater than two species and where nodes subtend species 
  that are sampled in multiple plots. 
  
  Note: whether for the empirical data or for permuted datasets, if fewer than two species are sampled in a given plot, the plot will be dynamically 
  removed from the dataset. This behavior can be controlled directly in \code{\link{spacodi.calc}} with the \code{prune} option.
    
  For significance testing, permuted datasets may be generated by one of several \code{methods}:
    \itemize{
	\item \code{method = "1a"} shuffling based on abundance classes of species (see \code{\link{resamp.1a}}); 
	requires specification of \code{abund.class.ratio} as a \code{parm} 
	
	\item \code{method = "1s"} shuffling of abundances across entire dataset (see \code{\link{resamp.1s}})

	\item \code{method = "2s"} shuffling of abundances across species but within plots (see \code{\link{resamp.2s}})
	
	\item \code{method = "2x"} Gotelli swapping of abundances for pairs of species and within a pair of plots (see \code{\link{resamp.2x}}); 
	requires specification of \code{level} as a \code{parm} 
	
	\item \code{method = "3i"} shuffling of abundances within species and among plots (see \code{\link{resamp.3i}})
	
	\item \code{method = "3t"} shuffling of abundances to adjacent plots but within species (see \code{\link{resamp.3t}}); if supplied, \code{dmat} 
	is used to condition abundance shuffling, where closer plots, on average, have higher likelihoods of abundances being swapped

	\item \code{method = "3x"} Gotelli swapping of abundances for pairs of plots and within a pair of species (see \code{\link{resamp.3x}}); 
	requires specification of \code{level} as a \code{parm} 
  }
}

\value{  
  \code{spacodi.by.nodes} returns a list of three elements:
  \itemize{
    \item \code{observed.sp.parm}{: estimated \code{sp.parm} for nodes of the tree (either all nodes, if \code{return.all=TRUE} or for only 
	those nodes for which \code{sp.parm} is non-null)}
	\item \code{expected.sp.parm}{: expected \code{sp.parm} for all nodes of the emprical data for which \code{sp.parm} is calculable; nodes in 
	this element of the output array are row names}
	\item \code{randomization.test}{: results from randomization tests of \code{sp.parm} for each node. Note: if randomization test is used, 
	some randomization iterations may return NA for particular nodes (see details above). The tally of valid expected 
	\code{sp.parm}s from permutation is recorded as a column in this element (i.e., \code{randomization.test$valid.comparisons}).  
	Be wary of significant results that are based off few valid comparisons.}
  }
}

\references{
  HARDY OJ and B SENTERRE. 2007. Characterizing the 
  phylogenetic structure of communities by an additive partitioning of 
  phylogenetic diversity. Journal of Ecology 95:493-506.
  
  HARDY OJ. 2008. Testing the spatial phylogenetic 
  structure of local communities: statistical performances of 
  different null models and test statistics on a locally neutral 
  community. Journal of Ecology 96:914-926.
}

\author{Jonathan Eastman and Timothy Paine}

\seealso{\code{\link{spacodi.calc}} for interpretation of results; \code{\link{resamp.test}}; \code{\link[picante]{randomizeMatrix}}}

\examples{
# load a species-by-plots matrix, along with a tree
data(sp.example)
attributes(sp.example)
attach(sp.example)
spl
phy

# generate a plot of observed and expected Bst
sp.permut<-spacodi.by.nodes(sp.plot=spl, phy=phy, n.rep=35)
sp.permut$randomization.test

# plot observed and expected Bst
spacodi.permutplot(spacodi.permutations=sp.permut, envelope=FALSE)

}

