% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{create_simulator}
\alias{create_simulator}
\title{Create surveillance data simulator.}
\usage{
create_simulator(times = seq(0, 9), t0 = min(times),
  process_model = c("SIR", "SIS"),
  transmission = c("density-dependent", "frequency-dependent"),
  params = c(gamma = 24, mu = 1/70, d = 1/70, eta = 1e-05, beta_par =
  1e-04, rho = 0.1, S_0 = 1, I_0 = 0, R_0 = 0, N_0 = 1e+05, p = 0),
  covar = data.frame(gamma_t = c(0, 0), mu_t = c(0, 0), d_t = c(0, 0),
  eta_t = c(0, 0), beta_par_t = c(0, 0), p_t = c(0, 0), time = c(0,
  1e+06)))
}
\arguments{
\item{times}{A numeric vector of increasing times at which the
state of the simulation will be sampled.}

\item{t0}{The time at which the simulation is started with state
variable set to the initial conditions specified via params.}

\item{process_model}{Character string giving the process
model. Allowed values are '"SIR"' and '"SIS"'.}

\item{transmission}{Character string describing the transmission
model. Allowed values are '"density-dependent"' and
'"frequency-dependent"'.}

\item{params}{A named numeric vector of parameter values and
initial conditions.}

\item{covar}{A data frame containing values of the time-dependent
components of the parameters.}
}
\value{
A pomp object with which simulations can be run via
\code{pomp::simulate}.
}
\description{
\code{create_simulator} creates a pomp object that will run
simulations of an SIR or SIS model according to Gillespie's direct
method and generate simulated observations of the process.
}
\details{
See the vignette "Getting Started with spaero" for a description of
the model. The "params" argument must include all model
parameters. These will become the default parameters for the model
object. They can be overridden when the simulation is run via the
"params" argument of \code{pomp::simulate}. The case is the same
for the "times" argument. The "covar" argument should be a data
frame with a column named for each of the time-dependent parameters
and a column named time. This data frame describes the time series
of each of the time-dependent parameters. In the simulation,
interpolation based on this data frame determines the value of
these parameters at specific instants in time. The user must ensure
that these values result in the parameters remaining non-negative
for the course of the simulation.
}
\examples{

foo <- create_simulator()
out <- pomp::simulate(foo, times = seq(0, 20, by = 1/26))
out <- as(out, "data.frame")
head(out)

opar <- par(mfrow = c(2, 1))
plot((S/N)~time, data = out, type = "l")
plot(cases~time, data = out, type = "l")
par(opar)

}
\seealso{
\code{\link[pomp]{pomp}} for documentation of pomp objects
}
