% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdsr.R
\name{tdsr}
\alias{tdsr}
\title{Time-domain spectral registration.}
\usage{
tdsr(mrs_data, ref = NULL, xlim = c(4, 0.5), max_t = 0.2)
}
\arguments{
\item{mrs_data}{MRS data to be corrected.}

\item{ref}{optional MRS data to use as a reference, the mean of all dynamics
is used if this argument is not supplied.}

\item{xlim}{optional frequency range to perform optimisation, set to NULL
to use the full range.}

\item{max_t}{truncate the FID when longer than max_t to reduce time taken.}
}
\value{
a list containing the corrected data; phase and shift values in units
of degrees and Hz respectively.
}
\description{
An implementation of the method published by Near et al MRM 73:44-50 (2015).
}
