% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_classes.R
\name{constructor_randomprojection}
\alias{constructor_randomprojection}
\title{Constructor function for building \code{'randomprojection'} objects}
\usage{
constructor_randomprojection(
  name,
  generate_fun,
  update_fun = NULL,
  update_rpm_w_data = NULL,
  control = list()
)
}
\arguments{
\item{name}{character}

\item{generate_fun}{function for generating the random projection matrix. This
function should have with arguments \code{rp}, which is a \code{'randomprojection'}
object, \code{m}, the target dimension and a vector of indexes
\code{included_vector}, \code{x} matrix of predictors and \code{y} matrix of predictors.
Vector \code{included_vector} shows the column index of the original variables in the
\code{x} matrix to be projected using the random projection. This is needed
due to the fact that screening is employed pre-projection.}

\item{update_fun}{function for updating the \code{'randomprojection'} object with
information from the data. This
function should have arguments \code{rp}, which is a \code{'randomprojection'}
object and \code{x} (the matrix of predictors)
and \code{y} (the vector of responses).}

\item{update_rpm_w_data}{function for updating the random projection matrix with data.
This can be used for the case where a list of random projection matrices is
provided by argument \code{RPMs}. In this case, the random structure is kept
fixed, but the data-dependent part gets updated with the provided data. Defaults
to NULL. If not provided, the values of the provided RPMs do not change.}

\item{control}{list of controls for random projection. Can include minimum and
maximum dimension for the projection defaults to
\code{list(mslow = NULL, msup = NULL)}}
}
\value{
a function which in turn creates an object of class \code{'randomprojection'}
}
\description{
Creates an object class \code{'randomprojection'} using arguments passed by user.
}
