/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.ObjectConversion;
import java.util.HashSet;
import java.util.Set;

public class BooleanConversion
extends ObjectConversion<Boolean> {
    private String defaultForTrue;
    private String defaultForFalse;
    private Set<String> falseValues = new HashSet<String>();
    private Set<String> trueValues = new HashSet<String>();

    public BooleanConversion(String[] valuesForTrue, String[] valuesForFalse) {
        this(null, null, valuesForTrue, valuesForFalse);
    }

    public BooleanConversion(Boolean valueIfStringIsNull, String valueIfObjectIsNull, String[] valuesForTrue, String[] valuesForFalse) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.notEmpty("Values for true", valuesForTrue);
        ArgumentUtils.notEmpty("Values for false", valuesForFalse);
        ArgumentUtils.fill(this.falseValues, valuesForFalse);
        ArgumentUtils.fill(this.trueValues, valuesForTrue);
        for (String falseValue : this.falseValues) {
            if (!this.trueValues.contains(falseValue)) continue;
            throw new IllegalArgumentException("Ambiguous string representation for both false and true values: '" + falseValue + "'");
        }
        this.defaultForTrue = valuesForTrue[0];
        this.defaultForFalse = valuesForFalse[0];
    }

    @Override
    public String revert(Boolean input) {
        if (input != null) {
            if (Boolean.FALSE.equals(input)) {
                return this.defaultForFalse;
            }
            if (Boolean.TRUE.equals(input)) {
                return this.defaultForTrue;
            }
        }
        return this.getValueIfObjectIsNull();
    }

    @Override
    protected Boolean fromString(String input) {
        if (input != null) {
            if (this.falseValues.contains(input)) {
                return Boolean.FALSE;
            }
            if (this.trueValues.contains(input)) {
                return Boolean.TRUE;
            }
            throw new IllegalArgumentException("Unable to convert '" + input + "' to Boolean. Allowed Strings are: " + this.trueValues + " for true; and " + this.falseValues + " for false.");
        }
        return (Boolean)super.getValueIfStringIsNull();
    }
}

