/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthWriterSettings;
import java.io.Writer;

public class FixedWidthWriter
extends AbstractWriter<FixedWidthWriterSettings> {
    private final boolean ignoreLeading;
    private final boolean ignoreTrailing;
    private final int[] fieldLengths;
    private final char padding;
    private int length;

    public FixedWidthWriter(Writer writer, FixedWidthWriterSettings settings) {
        super(writer, settings);
        FixedWidthFormat format = (FixedWidthFormat)settings.getFormat();
        this.padding = format.getPadding();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
        this.fieldLengths = settings.getFieldLengths();
    }

    @Override
    protected void processRow(Object[] row) {
        int lastIndex = this.fieldLengths.length < row.length ? this.fieldLengths.length : row.length;
        for (int i = 0; i < lastIndex; ++i) {
            this.length = this.fieldLengths[i];
            String nextElement = this.getStringValue(row[i]);
            this.processElement(nextElement);
            this.appendValueToRow();
        }
    }

    private void append(String element) {
        int start = 0;
        if (this.ignoreLeading) {
            start = this.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            int i = start;
            while (i < element.length() && this.length > 0) {
                while (i < element.length() && this.length-- > 0) {
                    char nextChar = element.charAt(i);
                    this.appender.appendIgnoringWhitespace(nextChar);
                    ++i;
                }
                if (this.length == -1 && this.appender.whitespaceCount() > 0) {
                    for (int j = i; j < element.length(); ++j) {
                        if (element.charAt(j) <= ' ') continue;
                        this.appender.resetWhitespaceCount();
                        break;
                    }
                    if (this.appender.whitespaceCount() > 0) {
                        this.length = 0;
                    }
                }
                this.length += this.appender.whitespaceCount();
                this.appendValueToRow();
            }
        } else {
            for (int i = start; i < element.length() && this.length-- > 0; ++i) {
                char nextChar = element.charAt(i);
                this.appender.append(nextChar);
            }
        }
    }

    private void processElement(String element) {
        if (element != null) {
            this.append(element);
        }
        while (this.length-- > 0) {
            this.appender.append(this.padding);
        }
    }
}

