% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_write_csv}
\alias{stream_write_csv}
\title{Write CSV Stream}
\usage{
stream_write_csv(x, path, mode = c("append", "complete", "update"),
  trigger = stream_trigger_interval(), checkpoint = file.path(path,
  "checkpoint"), header = TRUE, delimiter = ",", quote = "\\"",
  escape = "\\\\", charset = "UTF-8", null_value = NULL,
  options = list(), ...)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{mode}{Specifies how data is written to a streaming sink. Valid values are
\code{"append"}, \code{"complete"} or \code{"update"}.}

\item{trigger}{The trigger for the stream query, defaults to micro-batches runnnig
every 5 seconds. See \code{\link{stream_trigger_interval}} and
\code{\link{stream_trigger_continuous}}.}

\item{checkpoint}{The location where the system will write all the checkpoint
information to guarantee end-to-end fault-tolerance.}

\item{header}{Should the first row of data be used as a header? Defaults to \code{TRUE}.}

\item{delimiter}{The character used to delimit each column, defaults to \code{,}.}

\item{quote}{The character used as a quote. Defaults to \samp{'"'}.}

\item{escape}{The character used to escape other characters, defaults to \code{\\}.}

\item{charset}{The character set, defaults to \code{"UTF-8"}.}

\item{null_value}{The character to use for default values, defaults to \code{NULL}.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark dataframe stream into a tabular (typically, comma-separated) stream.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

dir.create("csv-in")
write.csv(iris, "csv-in/data.csv", row.names = FALSE)

csv_path <- file.path("file://", getwd(), "csv-in")

stream <- stream_read_csv(sc, csv_path) \%>\% stream_write_csv("csv-out")

stream_stop(stream)

}

}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_delta}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_kafka}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_parquet}},
  \code{\link{stream_read_socket}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_console}},
  \code{\link{stream_write_delta}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_parquet}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
