/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.matching.Regex;
import sparklyr.DFCollectionUtils$;
import sparklyr.StructTypeAsJSON;
import sparklyr.StructTypeAsJSON$;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public boolean[] collectColumnBoolean(Dataset<Row> df, String colName) {
        return (boolean[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$collectColumnBoolean$1(row)), ClassTag$.MODULE$.Boolean()).collect();
    }

    public int[] collectColumnInteger(Dataset<Row> df, String colName) {
        return (int[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectColumnInteger$1(row)), ClassTag$.MODULE$.Int()).collect();
    }

    public double[] collectColumnDouble(Dataset<Row> df, String colName) {
        return (double[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectColumnDouble$1(row)), ClassTag$.MODULE$.Double()).collect();
    }

    public String collectColumnString(Dataset<Row> df, String colName, String separator) {
        String text = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)row -> {
            Object element = row.apply(0);
            return element instanceof String ? (String)element : "<NA>";
        }, ClassTag$.MODULE$.apply(String.class)).collect())).mkString(separator);
        return text.length() > 0 ? new StringBuilder(0).append(text).append(separator).toString() : text;
    }

    public Object[] collectColumnDefault(Dataset<Row> df, String colName) {
        return (Object[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)row -> row.apply(0), ClassTag$.MODULE$.Any()).collect();
    }

    public Object collectColumn(Dataset<Row> df, String colName, String colType, String separator) {
        String string = colType;
        Object object = "BooleanType".equals(string) ? this.collectColumnBoolean(df, colName) : ("IntegerType".equals(string) ? (Object)this.collectColumnInteger(df, colName) : ("DoubleType".equals(string) ? (Object)this.collectColumnDouble(df, colName) : ("StringType".equals(string) ? (Object)this.collectColumnString(df, colName, separator) : (Object)this.collectColumnDefault(df, colName))));
        return object;
    }

    public int[] collectImplBoolean(Row[] local, Integer idx) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplBoolean$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[][] collectImplBooleanArrArr(Row[] local, Integer idx) {
        return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplBooleanArrArr$2(el, e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
    }

    public int[] collectImplInteger(Row[] local, Integer idx) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplInteger$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[][] collectImplIntegerArrArr(Row[] local, Integer idx) {
        return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplIntegerArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
    }

    public double[] collectImplDouble(Row[] local, Integer idx) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplDouble$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[][] collectImplDoubleArrArr(Row[] local, Integer idx) {
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (double[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplDoubleArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public double[] collectImplFloat(Row[] local, Integer idx) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplFloat$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[][] collectImplFloatArrArr(Row[] local, Integer idx) {
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (double[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplFloatArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public int[] collectImplByte(Row[] local, Integer idx) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplByte$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[][] collectImplByteArrArr(Row[] local, Integer idx) {
        return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplByteArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
    }

    public int[] collectImplShort(Row[] local, Integer idx) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplShort$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[][] collectImplShortArrArr(Row[] local, Integer idx) {
        return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$collectImplShortArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
    }

    public double[] collectImplLong(Row[] local, Integer idx) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplLong$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[][] collectImplLongArrArr(Row[] local, Integer idx) {
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (double[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplLongArrArr$2(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public String collectImplForceString(Row[] local, Integer idx, String separator) {
        String text = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            Object el = row.apply(Predef$.MODULE$.Integer2int(idx));
            return el != null ? el.toString() : "<NA>";
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(separator);
        return text.length() > 0 ? new StringBuilder(0).append(text).append(separator).toString() : text;
    }

    public String[][] collectImplForceStringArrArr(Row[] local, Integer idx, String separator) {
        return (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray locale = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (String[])((WrappedArray)locale.map((Function1 & Serializable & scala.Serializable)e -> e != null ? e.toString() : "<NA>", WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
    }

    public String collectImplString(Row[] local, Integer idx, String separator) {
        String text = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            Object el = row.apply(Predef$.MODULE$.Integer2int(idx));
            return el instanceof String ? (String)el : "<NA>";
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(separator);
        return text.length() > 0 ? new StringBuilder(0).append(text).append(separator).toString() : text;
    }

    public String[][] collectImplStringArrArr(Row[] local, Integer idx, String separator) {
        return (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray locale = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (String[])((WrappedArray)locale.map((Function1 & Serializable & scala.Serializable)e -> e instanceof String ? (String)e : "<NA>", WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
    }

    public double[] collectImplDecimal(Row[] local, Integer idx) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplDecimal$1(idx, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[][] collectImplDecimalArrArr(Row[] local, Integer idx) {
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray localel = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (double[])((WrappedArray)localel.map((Function1 & Serializable & scala.Serializable)el -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$collectImplDecimalArrArr$2(el)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public Object[] collectImplVector(Row[] local, Integer idx) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            Object el = row.apply(Predef$.MODULE$.Integer2int(idx));
            Object object = el;
            Object object2 = object == null ? Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()) : (object instanceof Seq ? ((Seq)el).toArray(ClassTag$.MODULE$.Any()) : el.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(el, new Object[0]));
            return object2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
    }

    public Object[] collectImplJSON(Row[] local, Integer idx) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            Object el = row.apply(Predef$.MODULE$.Integer2int(idx));
            Object object = el;
            Object[] objectArray = object instanceof String ? new StructTypeAsJSON((String)el) : MODULE$.collectImplDefault(local, idx);
            return objectArray;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
    }

    public Timestamp[] collectImplTimestamp(Row[] local, Integer idx) {
        return (Timestamp[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> (Timestamp)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Timestamp)row.getAs(Predef$.MODULE$.Integer2int(idx))).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)));
    }

    public Timestamp[][] collectImplTimestampArrArr(Row[] local, Integer idx) {
        return (Timestamp[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (Timestamp[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> (Timestamp)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Timestamp)e).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Timestamp.class))));
    }

    public Date[] collectImplDate(Row[] local, Integer idx) {
        return (Date[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Date)row.getAs(Predef$.MODULE$.Integer2int(idx))).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Date.class)));
    }

    public Date[][] collectImplDateArrArr(Row[] local, Integer idx) {
        return (Date[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> {
            WrappedArray el = (WrappedArray)row.apply(Predef$.MODULE$.Integer2int(idx));
            return (Date[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Date)e).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Date.class)))).toArray(ClassTag$.MODULE$.apply(Date.class));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Date.class))));
    }

    public Object[] collectImplDefault(Row[] local, Integer idx) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])local)).map((Function1 & Serializable & scala.Serializable)row -> row.apply(Predef$.MODULE$.Integer2int(idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
    }

    public Object collectImpl(Row[] local, Integer idx, String colType, String separator) {
        Object object;
        Regex ReDecimalType = new StringOps(Predef$.MODULE$.augmentString("(DecimalType.*)")).r();
        Regex ReVectorType = new StringOps(Predef$.MODULE$.augmentString("(.*VectorUDT.*)")).r();
        String string = colType;
        if ("BooleanType".equals(string)) {
            object = this.collectImplBoolean(local, idx);
        } else if ("IntegerType".equals(string)) {
            object = this.collectImplInteger(local, idx);
        } else if ("DoubleType".equals(string)) {
            object = this.collectImplDouble(local, idx);
        } else if ("StringType".equals(string)) {
            object = this.collectImplString(local, idx, separator);
        } else if ("LongType".equals(string)) {
            object = this.collectImplLong(local, idx);
        } else if ("ByteType".equals(string)) {
            object = this.collectImplByte(local, idx);
        } else if ("FloatType".equals(string)) {
            object = this.collectImplFloat(local, idx);
        } else if ("ShortType".equals(string)) {
            object = this.collectImplShort(local, idx);
        } else if ("Decimal".equals(string)) {
            object = this.collectImplForceString(local, idx, separator);
        } else if ("TimestampType".equals(string)) {
            object = this.collectImplTimestamp(local, idx);
        } else if ("CalendarIntervalType".equals(string)) {
            object = this.collectImplForceString(local, idx, separator);
        } else if ("DateType".equals(string)) {
            object = this.collectImplDate(local, idx);
        } else {
            Option option = ReDecimalType.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                object = this.collectImplDecimal(local, idx);
            } else {
                Option option2 = ReVectorType.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    object = this.collectImplVector(local, idx);
                } else {
                    String string2 = StructTypeAsJSON$.MODULE$.DType();
                    String string3 = string;
                    object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? (Object)this.collectImplJSON(local, idx) : ("ArrayType(BooleanType,true)".equals(string) ? (Object)this.collectImplBooleanArrArr(local, idx) : ("ArrayType(IntegerType,true)".equals(string) ? (Object)this.collectImplIntegerArrArr(local, idx) : ("ArrayType(DoubleType,true)".equals(string) ? (Object)this.collectImplDoubleArrArr(local, idx) : ("ArrayType(StringType,true)".equals(string) ? (Object)this.collectImplStringArrArr(local, idx, separator) : ("ArrayType(LongType,true)".equals(string) ? (Object)this.collectImplLongArrArr(local, idx) : ("ArrayType(ByteType,true)".equals(string) ? (Object)this.collectImplByteArrArr(local, idx) : ("ArrayType(FloatType,true)".equals(string) ? (Object)this.collectImplFloatArrArr(local, idx) : ("ArrayType(ShortType,true)".equals(string) ? (Object)this.collectImplShortArrArr(local, idx) : ("ArrayType(DecimalType,true)".equals(string) ? (Object)this.collectImplDecimalArrArr(local, idx) : ("ArrayType(TimestampType,true)".equals(string) ? (Object)this.collectImplTimestampArrArr(local, idx) : ("ArrayType(CalendarIntervalType,true)".equals(string) ? (Object)this.collectImplForceStringArrArr(local, idx, separator) : ("ArrayType(DateType,true)".equals(string) ? (Object)this.collectImplDateArrArr(local, idx) : ("ArrayType(BooleanType,false)".equals(string) ? (Object)this.collectImplBooleanArrArr(local, idx) : ("ArrayType(IntegerType,false)".equals(string) ? (Object)this.collectImplIntegerArrArr(local, idx) : ("ArrayType(DoubleType,false)".equals(string) ? (Object)this.collectImplDoubleArrArr(local, idx) : ("ArrayType(StringType,false)".equals(string) ? (Object)this.collectImplStringArrArr(local, idx, separator) : ("ArrayType(LongType,false)".equals(string) ? (Object)this.collectImplLongArrArr(local, idx) : ("ArrayType(ByteType,false)".equals(string) ? (Object)this.collectImplByteArrArr(local, idx) : ("ArrayType(FloatType,false)".equals(string) ? (Object)this.collectImplFloatArrArr(local, idx) : ("ArrayType(ShortType,false)".equals(string) ? (Object)this.collectImplShortArrArr(local, idx) : ("ArrayType(DecimalType,false)".equals(string) ? (Object)this.collectImplDecimalArrArr(local, idx) : ("ArrayType(TimestampType,false)".equals(string) ? (Object)this.collectImplTimestampArrArr(local, idx) : ("ArrayType(CalendarIntervalType,false)".equals(string) ? (Object)this.collectImplForceStringArrArr(local, idx, separator) : ("ArrayType(DateType,false)".equals(string) ? (Object)this.collectImplDateArrArr(local, idx) : ("NullType".equals(string) ? (Object)this.collectImplForceString(local, idx, separator) : (Object)this.collectImplDefault(local, idx))))))))))))))))))))))))));
                }
            }
        }
        return object;
    }

    public Object collectArray(Row[] local, Tuple2<String, String>[] dtypes, String separator) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dtypes.length).map((Function1 & Serializable & scala.Serializable)i -> Utils$.MODULE$.collectImpl(local, Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), (String)dtypes[BoxesRunTime.unboxToInt((Object)i)]._2(), separator), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
    }

    public Object collect(Dataset<Row> df, String separator) {
        String[] columns = df.columns();
        Tuple2<Dataset<Row>, Tuple2<String, String>[]> tuple2 = DFCollectionUtils$.MODULE$.prepareDataFrameForCollection(df);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset transformed_df = (Dataset)tuple2._1();
        Tuple2[] dtypes = (Tuple2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transformed_df, (Object)dtypes);
        Tuple2 tuple23 = tuple22;
        Dataset transformed_df2 = (Dataset)tuple23._1();
        Tuple2[] dtypes2 = (Tuple2[])tuple23._2();
        Row[] local = (Row[])transformed_df2.collect();
        return this.collectArray(local, dtypes2, separator);
    }

    public Dataset<Row> separateColumnArray(Dataset<Row> df, String column, String[] names, int[] indices) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$2 -> df.apply(x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), names.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = names[i];
            int index = indices[i];
            colexprs$1.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$1.elem))).$colon$plus((Object)((Column)col$1.elem).getItem((Object)BoxesRunTime.boxToInteger((int)index)).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumnVector(Dataset<Row> df, String column, String[] names, int[] indices) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$3 -> df.apply(x$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        UserDefinedFunction extractor = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, i) -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$separateColumnVector$2(x, BoxesRunTime.unboxToInt((Object)i))), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), names.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = names[i];
            int index = indices[i];
            colexprs$2.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$2.elem))).$colon$plus((Object)extractor.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)col$2.elem, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)index))})).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumnStruct(Dataset<Row> df, String column, String[] names, int[] indices, boolean intoIsSet) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$4 -> df.apply(x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        String[] fieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select(column, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).schema().fields())).flatMap((Function1 & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Utils$.$anonfun$separateColumnStruct$2(f)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] outNames = intoIsSet ? names : fieldNames;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outNames.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = outNames[i];
            int index = indices[i];
            colexprs$3.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$3.elem))).$colon$plus((Object)((Column)col$3.elem).getItem((Object)fieldNames[index]).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumn(Dataset<Row> df, String column, String[] names, int[] indices, boolean intoIsSet) {
        Dataset<Row> dataset;
        Column col = df.apply(column);
        StructType schema = df.schema();
        String typeName = schema.apply(schema.fieldIndex(column)).dataType().typeName();
        String string = typeName;
        if ("array".equals(string)) {
            dataset = this.separateColumnArray(df, column, names, indices);
        } else if ("vector".equals(string)) {
            dataset = this.separateColumnVector(df, column, names, indices);
        } else if ("struct".equals(string)) {
            dataset = this.separateColumnStruct(df, column, names, indices, intoIsSet);
        } else {
            throw new IllegalArgumentException(new StringBuilder(17).append("unhandled type '").append(typeName).append("'").toString());
        }
        return dataset;
    }

    public RDD<Row> createDataFrame(SparkContext sc, Object rows, int partitions) {
        Row[] data = (Row[])Predef$.MODULE$.genericArrayOps(rows).map((Function1 & Serializable & scala.Serializable)o -> {
            Object r = o;
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray(r));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        return sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])data), partitions, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> createDataFrameFromText(SparkContext sc, String[] rows, String[] columns, int partitions, String separator) {
        Row[] data = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)o -> {
            String[] r = o.split(separator, -1);
            Object[] typed = (Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, r.length))).map((Function1 & Serializable & scala.Serializable)idx -> Utils$.$anonfun$createDataFrameFromText$2(columns, r, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)typed));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        return sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])data), partitions, ClassTag$.MODULE$.apply(Row.class));
    }

    public boolean classExists(String name) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(name)).isSuccess();
    }

    public RDD<Row> createDataFrameFromCsv(SparkContext sc, String path, String[] columns, int partitions, String separator) {
        IndexedSeq lines = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).getLines().toIndexedSeq();
        RDD rddRows = sc.parallelize((Seq)lines, partitions, ClassTag$.MODULE$.apply(String.class));
        RDD data = rddRows.map((Function1 & Serializable & scala.Serializable)o -> {
            String[] r = o.split(separator, -1);
            Object[] typed = (Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, r.length))).map((Function1 & Serializable & scala.Serializable)idx -> Utils$.$anonfun$createDataFrameFromCsv$2(columns, r, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)typed));
        }, ClassTag$.MODULE$.apply(Row.class));
        return data;
    }

    public Dataset<Row> addSequentialIndex(Dataset<Row> df, int from, String id) {
        SQLContext sqlContext = df.sqlContext();
        return sqlContext.createDataFrame(df.rdd().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long i;
            Row row;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    row = (Row)tuple2._1();
                    i = tuple2._2$mcJ$sp();
                    if (row != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Row row2 = row;
            long l = i;
            Row row3 = Row$.MODULE$.fromSeq((Seq)row2.toSeq().$colon$plus((Object)BoxesRunTime.boxToDouble((double)((double)l + (double)from)), Seq$.MODULE$.canBuildFrom()));
            return row3;
        }, ClassTag$.MODULE$.apply(Row.class)), df.schema().add(id, "double"));
    }

    public double getLastIndex(Dataset<Row> df, String id) {
        int numPartitions = df.rdd().partitions().length;
        RDD qual$1 = df.select(id, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd();
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(i, iter) -> Utils$.$anonfun$getLastIndex$1(numPartitions, BoxesRunTime.unboxToInt((Object)i), iter);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        return ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)).collect())).last()).getDouble(0);
    }

    public String unboxString(Option<String> x) {
        String string;
        Option<String> option = x;
        if (option instanceof Some) {
            String s;
            Some some = (Some)option;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String[] getAncestry(Object obj, boolean simpleName) {
        return (String[])((TraversableOnce)Utils$.supers$1(obj.getClass()).map((Function1)(simpleName ? (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getSimpleName() : (Function1 & Serializable & scala.Serializable)x$8 -> x$8.getName()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean getAncestry$default$2() {
        return true;
    }

    public boolean portIsAvailable(int port, InetAddress inetAddress) {
        ObjectRef ss = ObjectRef.create(null);
        BooleanRef available = BooleanRef.create((boolean)false);
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ss$1.elem = new ServerSocket(port, 1, inetAddress);
            available$1.elem = true;
        });
        Object object = (ServerSocket)ss.elem != null ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ServerSocket)ss$1.elem).close()) : BoxedUnit.UNIT;
        return available.elem;
    }

    public int nextPort(int port, InetAddress inetAddress) {
        int freePort = port + 1;
        while (!this.portIsAvailable(freePort, inetAddress) && freePort - port < 100) {
            ++freePort;
        }
        return freePort - port < 100 ? freePort : 0;
    }

    public StructType buildStructTypeForIntegerField() {
        StructField[] fields = (StructField[])((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())});
        return new StructType(fields);
    }

    public StructType buildStructTypeForLongField() {
        StructField[] fields = (StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())});
        return new StructType(fields);
    }

    public RDD<Row> mapRddLongToRddRow(RDD<Object> rdd) {
        return rdd.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x))})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> mapRddIntegerToRddRow(RDD<Object> rdd) {
        return rdd.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToLong((Object)x)))})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> readWholeFiles(SparkContext sc, String inputPath) {
        return sc.wholeTextFiles(inputPath, sc.wholeTextFiles$default$2()).map((Function1 & Serializable & scala.Serializable)l -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l._1(), l._2()})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> unionRdd(SparkContext context, Seq<RDD<Row>> rdds) {
        return context.union(rdds, ClassTag$.MODULE$.apply(Row.class));
    }

    public Object collectIter(Iterator<Row> iter, Integer size, Dataset<Row> df, String separator) {
        Row[] local = (Row[])iter.take(Predef$.MODULE$.Integer2int(size)).toArray(ClassTag$.MODULE$.apply(Row.class));
        Tuple2[] dtypes = df.dtypes();
        return this.collectArray(local, dtypes, separator);
    }

    public static final /* synthetic */ boolean $anonfun$collectColumnBoolean$1(Row row) {
        return BoxesRunTime.unboxToBoolean((Object)row.apply(0));
    }

    public static final /* synthetic */ int $anonfun$collectColumnInteger$1(Row row) {
        Object element = row.apply(0);
        return element instanceof Integer ? BoxesRunTime.unboxToInt((Object)element) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ double $anonfun$collectColumnDouble$1(Row row) {
        Object element = row.apply(0);
        return element instanceof Double ? BoxesRunTime.unboxToDouble((Object)element) : Double.NaN;
    }

    public static final /* synthetic */ int $anonfun$collectImplBoolean$1(Integer idx$1, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$1));
        return el instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)el) ? 1 : 0) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplBooleanArrArr$2(WrappedArray el$1, Object e) {
        return e instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)el$1) ? 1 : 0) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplInteger$1(Integer idx$3, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$3));
        return el instanceof Integer ? BoxesRunTime.unboxToInt((Object)el) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplIntegerArrArr$2(Object e) {
        return e instanceof Integer ? BoxesRunTime.unboxToInt((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ double $anonfun$collectImplDouble$1(Integer idx$5, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$5));
        return el instanceof Double ? BoxesRunTime.unboxToDouble((Object)el) : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplDoubleArrArr$2(Object e) {
        return e instanceof Double ? BoxesRunTime.unboxToDouble((Object)e) : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplFloat$1(Integer idx$7, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$7));
        return el instanceof Float ? (double)BoxesRunTime.unboxToFloat((Object)el) : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplFloatArrArr$2(Object e) {
        return e instanceof Float ? (double)BoxesRunTime.unboxToFloat((Object)e) : Double.NaN;
    }

    public static final /* synthetic */ int $anonfun$collectImplByte$1(Integer idx$9, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$9));
        return el instanceof Byte ? (int)BoxesRunTime.unboxToByte((Object)el) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplByteArrArr$2(Object e) {
        return e instanceof Byte ? (int)BoxesRunTime.unboxToByte((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplShort$1(Integer idx$11, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$11));
        return el instanceof Short ? (int)BoxesRunTime.unboxToShort((Object)el) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectImplShortArrArr$2(Object e) {
        return e instanceof Short ? (int)BoxesRunTime.unboxToShort((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ double $anonfun$collectImplLong$1(Integer idx$13, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$13));
        return el instanceof Long ? (double)BoxesRunTime.unboxToLong((Object)el) : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplLongArrArr$2(Object e) {
        return e instanceof Long ? (double)BoxesRunTime.unboxToLong((Object)e) : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplDecimal$1(Integer idx$19, Row row) {
        Object el = row.apply(Predef$.MODULE$.Integer2int(idx$19));
        return el instanceof BigDecimal ? ((BigDecimal)el).doubleValue() : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$collectImplDecimalArrArr$2(Object el) {
        return el instanceof BigDecimal ? ((BigDecimal)el).doubleValue() : Double.NaN;
    }

    public static final /* synthetic */ double $anonfun$separateColumnVector$2(Object x, int i) {
        Object el = x.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(x, new Object[0]);
        double[] array = (double[])el;
        return array[i];
    }

    public static final /* synthetic */ Object[] $anonfun$separateColumnStruct$2(StructField f) {
        DataType dataType = f.dataType();
        if (!(dataType instanceof StructType)) {
            throw new MatchError((Object)dataType);
        }
        StructType structType = (StructType)dataType;
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])structType.fields());
        return objectArray;
    }

    public static final /* synthetic */ Object $anonfun$createDataFrameFromText$2(String[] columns$1, String[] r$1, int idx) {
        Object object;
        String column = columns$1[idx];
        String value = r$1[idx];
        String string = column;
        if ("integer".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toInt()).isSuccess() ? BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value)).toInt()) : null;
        } else if ("double".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()).isSuccess() ? (Number)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()) : (Number)null;
        } else if ("logical".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean()).isSuccess() ? BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean()) : null;
        } else if ("timestamp".equals(string)) {
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Timestamp(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 1000L)).isSuccess() ? new Timestamp(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 1000L) : null;
        } else if ("date".equals(string)) {
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Date(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000L)).isSuccess() ? new Date(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000L) : null;
        } else {
            String string2 = value;
            String string3 = "NA";
            object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? null : value;
        }
        return object;
    }

    public static final /* synthetic */ Object $anonfun$createDataFrameFromCsv$2(String[] columns$2, String[] r$2, int idx) {
        Object object;
        String column = columns$2[idx];
        String value = r$2[idx];
        String string = column;
        if ("integer".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toInt()).isSuccess() ? BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value)).toInt()) : null;
        } else if ("double".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()).isSuccess() ? (Number)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()) : (Number)null;
        } else if ("logical".equals(string)) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean()).isSuccess() ? BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean()) : null;
        } else if ("timestamp".equals(string)) {
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Timestamp(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 1000L)).isSuccess() ? new Timestamp(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 1000L) : null;
        } else if ("date".equals(string)) {
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Date(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000L)).isSuccess() ? new Date(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000L) : null;
        } else {
            String string2 = value;
            String string3 = "NA";
            object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? null : value;
        }
        return object;
    }

    public static final /* synthetic */ Iterator $anonfun$getLastIndex$1(int numPartitions$1, int i, Iterator iter) {
        return i != numPartitions$1 - 1 || iter.isEmpty() ? iter : package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new Tuple2(iter.next(), (Object)BoxesRunTime.boxToBoolean((boolean)iter.hasNext()))).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Row, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Row value = (Row)A1._1();
                    boolean bl = A1._2$mcZ$sp();
                    if (!bl) {
                        object = value;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Row, Object> x1) {
                boolean bl;
                Tuple2<Row, Object> tuple2 = x1;
                boolean bl2 = tuple2 != null && !(bl = tuple2._2$mcZ$sp());
                return bl2;
            }
        }).take(1);
    }

    private static final List supers$1(Class cl) {
        Nil$ nil$;
        if (cl == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Class clazz = cl;
            nil$ = Utils$.supers$1(cl.getSuperclass()).$colon$colon((Object)clazz);
        }
        return nil$;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

