/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.OrderedProxy;
import scala.runtime.RichBoolean;
import scala.runtime.ScalaRunTime$;
import sparklyr.DaysSinceEpoch;
import sparklyr.Logical;
import sparklyr.Numeric;

public final class Serializer$ {
    public static final Serializer$ MODULE$ = new Serializer$();
    private static final long kMsPerDay = 86400000L;

    public char readObjectType(DataInputStream dis) {
        if (dis == null) {
            throw null;
        }
        return (char)dis.readUnsignedByte();
    }

    public byte[] readBytes(DataInputStream in) {
        byte[] out = new byte[in.readInt()];
        in.readFully(out, 0, out.length);
        return out;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        if (in == null) {
            throw null;
        }
        in.readFully(bytes, 0, bytes.length);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        return new String((byte[])ArrayOps$.MODULE$.dropRight$extension((Object)bytes, 1), StandardCharsets.UTF_8);
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        return in.readInt() != 0;
    }

    public Date readDate(DataInputStream in) {
        int n = in.readInt();
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return new Date((long)n * kMsPerDay);
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)StrictMath.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public byte[][] readBytesArr(DataInputStream in) {
        byte[] byArray;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            byArray = Serializer$.MODULE$.readBytes(in);
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            byArray = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        byArray = null;
        return (byte[][])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    /*
     * WARNING - void declaration
     */
    public int[] readIntArr(DataInputStream in) {
        Integer n;
        int len = in.readInt();
        int n2 = 0;
        Range.Exclusive map_this = new Range.Exclusive(n2, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            int n3 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            n = BoxesRunTime.boxToInteger((int)Serializer$.MODULE$.readInt(in));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        n = null;
        return (int[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    /*
     * WARNING - void declaration
     */
    public double[] readDoubleArr(DataInputStream in) {
        Double d;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            int n2 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            d = BoxesRunTime.boxToDouble((double)Serializer$.MODULE$.readDouble(in));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            d = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        d = null;
        return (double[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Double());
    }

    /*
     * WARNING - void declaration
     */
    public boolean[] readBooleanArr(DataInputStream in) {
        Boolean bl;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            int n2 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            bl = BoxesRunTime.boxToBoolean((boolean)Serializer$.MODULE$.readBoolean(in));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            bl = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        bl = null;
        return (boolean[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Boolean());
    }

    /*
     * WARNING - void declaration
     */
    public String[] readStringArr(DataInputStream in) {
        String string;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            string = Serializer$.MODULE$.readString(in);
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        string = null;
        return (String[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    /*
     * WARNING - void declaration
     */
    public Date[] readDateArr(DataInputStream in) {
        Date date;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            date = Serializer$.MODULE$.readDate(in);
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            date = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        date = null;
        return (Date[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp[] readTimeArr(DataInputStream in) {
        Timestamp timestamp;
        int len = in.readInt();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, len, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            timestamp = Serializer$.MODULE$.readTime(in);
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            timestamp = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        timestamp = null;
        return (Timestamp[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        switch (typeStr == null ? 0 : typeStr.hashCode()) {
            case -1325958191: {
                if (!"double".equals(typeStr)) break;
                dos.writeByte(100);
                return;
            }
            case 107868: {
                if (!"map".equals(typeStr)) break;
                dos.writeByte(101);
                return;
            }
            case 112680: {
                if (!"raw".equals(typeStr)) break;
                dos.writeByte(114);
                return;
            }
            case 3076014: {
                if (!"date".equals(typeStr)) break;
                dos.writeByte(68);
                return;
            }
            case 3267661: {
                if (!"jobj".equals(typeStr)) break;
                dos.writeByte(106);
                return;
            }
            case 3271912: {
                if (!"json".equals(typeStr)) break;
                dos.writeByte(74);
                return;
            }
            case 3322014: {
                if (!"list".equals(typeStr)) break;
                dos.writeByte(108);
                return;
            }
            case 3560141: {
                if (!"time".equals(typeStr)) break;
                dos.writeByte(116);
                return;
            }
            case 3625364: {
                if (!"void".equals(typeStr)) break;
                dos.writeByte(110);
                return;
            }
            case 93090393: {
                if (!"array".equals(typeStr)) break;
                dos.writeByte(97);
                return;
            }
            case 342334473: {
                if (!"logical".equals(typeStr)) break;
                dos.writeByte(98);
                return;
            }
            case 1048993935: {
                if (!"sparkapplybinaryresult".equals(typeStr)) break;
                dos.writeByte(36);
                return;
            }
            case 1564195625: {
                if (!"character".equals(typeStr)) break;
                dos.writeByte(99);
                return;
            }
            case 1787751112: {
                if (!"strarray".equals(typeStr)) break;
                dos.writeByte(102);
                return;
            }
            case 1958052158: {
                if (!"integer".equals(typeStr)) break;
                dos.writeByte(105);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(typeStr).toString());
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeNumeric(DataOutputStream out, Numeric x) {
        if (x.value().isEmpty()) {
            out.writeInt(0x7FF00000);
            out.writeInt(1954);
            return;
        }
        double writeDouble_value = BoxesRunTime.unboxToDouble((Object)x.value().get());
        out.writeDouble(writeDouble_value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        out.writeInt(OrderedProxy.compare$((OrderedProxy)new RichBoolean(value), (Object)false));
    }

    public void writeLogical(DataOutputStream out, Logical value) {
        out.writeInt(value.intValue());
    }

    public void writeDate(DataOutputStream out, Date value) {
        int writeInt_value = value == null ? Integer.MIN_VALUE : (int)(value.getTime() / kMsPerDay);
        out.writeInt(writeInt_value);
    }

    public void writeDate(DataOutputStream out, DaysSinceEpoch d) {
        Option<Object> option = d.value();
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? Integer.valueOf(Integer.MIN_VALUE) : getOrElse_this.get();
        Object var3_3 = null;
        int writeInt_value = BoxesRunTime.unboxToInt((Object)object);
        out.writeInt(writeInt_value);
    }

    public double timestampToSeconds(java.util.Date value) {
        if (value == null) {
            return Double.NaN;
        }
        double seconds = (double)value.getTime() / 1000.0;
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return seconds + (double)timestamp.getNanos() / 1.0E9;
        }
        return seconds;
    }

    public void writeTime(DataOutputStream out, java.util.Date value) {
        out.writeDouble(this.timestampToSeconds(value));
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        if (value == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        for (int n : value) {
            out.writeInt(n);
        }
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        for (double d : value) {
            out.writeDouble(d);
        }
    }

    public void writeNumericArr(DataOutputStream out, Numeric[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        for (Numeric numeric : value) {
            Serializer$.MODULE$.writeNumeric(out, numeric);
        }
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        for (boolean bl : value) {
            Serializer$.MODULE$.writeBoolean(out, bl);
        }
    }

    public void writeLogicalArr(DataOutputStream out, Logical[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        for (Logical logical : value) {
            Serializer$.$anonfun$writeLogicalArr$1(out, logical);
        }
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        for (Timestamp timestamp : value) {
            Serializer$.MODULE$.writeTime(out, timestamp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeStringArr(DataOutputStream out, String[] value) {
        void mkString_end;
        void mkString_sep;
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])value);
        String string = "\u0019";
        if (ofRef2 == null) {
            throw null;
        }
        ArraySeq.ofRef mkString_this = ofRef2;
        String string2 = "";
        String mkString_start = "";
        Object var6_6 = null;
        string2 = null;
        Object var4_4 = null;
        string = null;
        String all = IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end);
        this.writeString(out, all);
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        for (Date date : value) {
            Serializer$.MODULE$.writeDate(out, date);
        }
    }

    public void writeDateArr(DataOutputStream out, DaysSinceEpoch[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        for (DaysSinceEpoch daysSinceEpoch : value) {
            Serializer$.MODULE$.writeDate(out, daysSinceEpoch);
        }
    }

    public static final /* synthetic */ int $anonfun$writeDate$1() {
        return Integer.MIN_VALUE;
    }

    public static final /* synthetic */ void $anonfun$writeIntArr$1(DataOutputStream out$1, int v) {
        out$1.writeInt(v);
    }

    public static final /* synthetic */ void $anonfun$writeDoubleArr$1(DataOutputStream out$2, double v) {
        out$2.writeDouble(v);
    }

    public static final /* synthetic */ void $anonfun$writeLogicalArr$1(DataOutputStream out$5, Logical v) {
        int writeInt_value = v.intValue();
        out$5.writeInt(writeInt_value);
    }

    private Serializer$() {
    }

    public static final /* synthetic */ byte[] $anonfun$readBytesArr$1$adapted(DataInputStream in$1, Object x$1) {
        return Serializer$.MODULE$.readBytes(in$1);
    }

    public static final /* synthetic */ String $anonfun$readStringArr$1$adapted(DataInputStream in$5, Object x$5) {
        return Serializer$.MODULE$.readString(in$5);
    }

    public static final /* synthetic */ Date $anonfun$readDateArr$1$adapted(DataInputStream in$6, Object x$6) {
        return Serializer$.MODULE$.readDate(in$6);
    }

    public static final /* synthetic */ Timestamp $anonfun$readTimeArr$1$adapted(DataInputStream in$7, Object x$7) {
        return Serializer$.MODULE$.readTime(in$7);
    }

    public static final /* synthetic */ Object $anonfun$writeNumericArr$1$adapted(DataOutputStream out$3, Numeric v) {
        Serializer$.MODULE$.writeNumeric(out$3, v);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeBooleanArr$1$adapted(DataOutputStream out$4, Object v) {
        Serializer$.MODULE$.writeBoolean(out$4, BoxesRunTime.unboxToBoolean((Object)v));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeLogicalArr$1$adapted(DataOutputStream out$5, Logical v) {
        Serializer$.$anonfun$writeLogicalArr$1(out$5, v);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeTimestampArr$1$adapted(DataOutputStream out$6, Timestamp v) {
        Serializer$.MODULE$.writeTime(out$6, v);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeDateArr$1$adapted(DataOutputStream out$7, Date v) {
        Serializer$.MODULE$.writeDate(out$7, v);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeDateArr$2$adapted(DataOutputStream out$8, DaysSinceEpoch v) {
        Serializer$.MODULE$.writeDate(out$8, v);
        return BoxedUnit.UNIT;
    }
}

