% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{Matrix.to.Pointers}
\alias{Matrix.to.Pointers}
\title{Extract row and column indices, pointers and values from a
sparse matrix.}
\usage{
Matrix.to.Pointers(M, as.symmetric = Matrix::isSymmetric(M), values = !is(M,
  "nMatrix"), order = NULL, index1 = TRUE)
}
\arguments{
\item{M}{A sparse Matrix, as defined in the Matrix package.}

\item{as.symmetric}{Defaults to isSymmetric(M).  If M is symmetric,
and as.symmetric is FALSE, then index/pointer elements in the
output list will be labeled according to order. If M is not
symmetric, and as.symmetric is TRUE, then an error will be triggered.}

\item{values}{If TRUE, values are returned in list as 'x'.
Defaults to TRUE for numeric and logical matrices, and FALSE for
pattern matrices.  If M is a pattern matrix, values=TRUE will
trigger a warning.}

\item{order}{Determines the indexing/compression scheme for the
output matrix.  Use 'triplet" to get row and column indices.
Defaults to the same class as M.}

\item{index1}{TRUE (default) if return indices and pointers should
use 1-based indexing.  FALSE for 0-based indexing.}
}
\value{
A list with the following elements. If order=='row',
\describe{
\item{jCol}{ Integer vector containing column indices of non-zero elements}
\item{ipntr}{ Integer vector containing pointers to elements of
jCol at which the next row begins.}
}
If order=='column'
 \describe{
\item{iRow}{ Integer vector containing row indices of non-zero elements}
\item{jpntr}{ Integer vector containing pointers to elements of
iRow at which the next column begins.}
}
If order=='triplet'
\describe{
\item{rows}{Row indices of non-zero elements}
\item{cols}{Column indices of non-zero elements}
}
If as.symmetric is TRUE, then the row/column orientation does not matter.
 \describe{
\item{idx}{ Integer vector containing indices of non-zero elements}
\item{pntr}{ Integer vector containing pointers to elements of idx
at which the next row or column begins.}
}
If values=TRUE, the return list includes x, the values of the
non-zero elements.
The 'class' element is the name of the sparse matrix class to which
the output corresponds (identifies numeric type, pattern, and
indexing/compression scheme).
}
\description{
Returns a list of row indices, column indices,
pointers, and/or values of a sparse Hessian.
}
\details{
This function is included primarily for debugging
purposes.  It is used internally, but would not ordinarily be
called by an end user.
}
\seealso{
Matrix.to.Coord
}

