% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_is_na.R
\name{sparse_is_na}
\alias{sparse_is_na}
\title{Detect Pressence of Missing Values}
\usage{
sparse_is_na(x, type = "logical")
}
\arguments{
\item{x}{A sparse vector.}

\item{type}{A single string. Most be one of \code{logical} or \code{integer}.
Determines the resulting vector. If \code{type = integer} then a sparse vector is
returned.}
}
\value{
A logical vector or sparse integer vector.
}
\description{
Detect Pressence of Missing Values
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.

Note that the resulting vector will be not be a sparse vector.
}
\examples{
sparse_is_na(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000)
)

sparse_is_na(
  sparse_double(c(10, NA, 11), c(1, 50, 111), 1000),
  type = "integer"
)
}
\seealso{
\code{\link[=sparse_which_na]{sparse_which_na()}}
}
