% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ssest.r
\name{summary.ssest}
\alias{summary.ssest}
\title{Summarizing Initial Sample Size Estimates}
\usage{
\method{summary}{ssest}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{ssest}".}

\item{...}{Arguments to be passed to or from other methods.}
}
\description{
\code{summary} method for class "\code{ssest}".
}
\details{
\code{summary.ssest} gives back initial sample size estimates required. Furthermore, inputs are displayed for double checking.
}
\examples{
#Calculate required sample size to find significant difference with
#80\% probability when testing the Nullhypothesis H_0: mu_T/mu_C >= 1
#assuming the true effect delta is 0.8 and rate, size and correlation
#parameter in the control group are 2, 1 and 0.5, respectively.

estimate<-n.nb.inar1(alpha=0.025, power=0.8, delta=0.8, muC=2, size=1, rho=0.5, tp=7, k=1)
summary(estimate)
}
\seealso{
\code{\link{n.nb.inar1}} for initial sample size estimates within the NB-INAR(1) model.
}
