% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibpf.R
\name{ibpf}
\alias{ibpf}
\alias{ibpf-missing}
\alias{ibpf,missing-method}
\alias{ibpf-ANY}
\alias{ibpf,ANY-method}
\alias{ibpf-spatPomp}
\alias{ibpf,spatPomp-method}
\alias{ibpf-ibpfd_spatPomp}
\alias{ibpf,ibpfd_spatPomp-method}
\alias{ibpf-bpfd_spatPomp}
\alias{ibpf,bpfilterd_spatPomp-method}
\title{Iterated block particle filter (IBPF)}
\usage{
\S4method{ibpf}{missing}(data, ...)

\S4method{ibpf}{ANY}(data, ...)

\S4method{ibpf}{spatPomp}(
  data,
  Nbpf,
  Np,
  rw.sd,
  sharedParNames,
  unitParNames,
  cooling.type = "geometric",
  cooling.fraction.50,
  block_size,
  block_list,
  spat_regression,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{ibpf}{ibpfd_spatPomp}(
  data,
  Nbpf,
  Np,
  rw.sd,
  sharedParNames,
  unitParNames,
  cooling.type = "geometric",
  cooling.fraction.50,
  block_size,
  block_list,
  spat_regression,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{ibpf}{bpfilterd_spatPomp}(
  data,
  Nbpf,
  Np,
  rw.sd,
  sharedParNames,
  unitParNames,
  cooling.type = "geometric",
  cooling.fraction.50,
  block_size,
  block_list,
  spat_regression,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be internally coerced to an array with storage-mode \code{double}.}

\item{...}{If a \code{params} argument is specified, \code{bpfilter} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{Nbpf}{the number of iterations of perturbed BPF.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{rw.sd}{specification of the magnitude of the random-walk perturbations that will be applied to some or all model parameters.
Parameters that are to be estimated should have positive perturbations specified here.
The specification is given using the \code{\link[pomp]{rw.sd}} function, which creates a list of unevaluated expressions.
The latter are evaluated in a context where the model time variable is defined (as \code{time}).
The expression \code{ivp(s)} can be used in this context as shorthand for \preformatted{ifelse(time==time[1],s,0).}
Likewise, \code{ivp(s,lag)} is equivalent to \preformatted{ifelse(time==time[lag],s,0).}
See below for some examples.

The perturbations that are applied are normally distributed with the specified s.d.
If parameter transformations have been supplied, then the perturbations are applied on the transformed (estimation) scale.}

\item{sharedParNames}{estimated parameters that are equal for each unit.}

\item{unitParNames}{estimated parameters that are different for
each unit.}

\item{cooling.type, cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{block_size}{The number of spatial units per block. If this is provided, the method subdivides units approximately evenly
into blocks with size \code{block_size}.}

\item{block_list}{List that specifies an exact partition of the spatial units. Each partition element, or block, is
an integer vector of neighboring units.}

\item{spat_regression}{Fraction of each extended parameter regressed toward the unit mean. Not required when all parameters are unit-specific.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{ibpf} returns an object of class
\sQuote{ibpfd_spatPomp}.
}
\description{
An iterated block particle filter, for both shared and unit-specific
parameters. We require that the spatPomp has
been constructed to have a unit-specific parameter "thetau"
for unit u corresponding to an estimated parameter "theta", whether
theta is shared or unit-specific. This permits IBPF
to implement a spatiotemporal random walk to estimate theta.
We require that rw.sd is positive for, and only for, all parameters
of the form "thetau" if "theta" is listed in sharedParNames or
unitParNames.
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{coef}}}{ gives the Monte Carlo estimate of the maximum likelihood. }
}
}

\references{
\ionides2022
}
\seealso{
likelihood evaluation algorithms: \code{girf()}, \code{enkf()}, \code{bpfilter()}, \code{abf()}, \code{abfir()}

Other likelihood maximization algorithms: 
\code{\link{ienkf}()},
\code{\link{igirf}()},
\code{\link{iubf}()}
}
\author{
Edward L. Ionides
}
\concept{likelihood maximization algorithms}
