% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vrm.R
\name{vrm}
\alias{vrm}
\title{Vector Ruggedness Measure (VRM)}
\usage{
vrm(x, s = 3, file.name = NULL, ...)
}
\arguments{
\item{x}{Elevation raster class object}

\item{s}{Scale of window. Must be odd number, can represent 2 dimensions (eg., s=c(3,5) would represent a 3 x 5 window)}

\item{file.name}{Name of output raster (optional)}

\item{...}{Additional arguments passed to writeRaster}
}
\value{
raster class object or raster written to disk
}
\description{
Implementation of the Sappington et al., (2007) vector ruggedness measure
}
\note{
This funtion measures terrain ruggedness by calculating the vector ruggedness measure
}
\examples{
 library(raster)
 data(elev)
   vrm3 <- vrm(elev) 
   vrm5 <- vrm(elev, s=5)
   plot(stack(vrm3, vrm5))

}
\references{
Sappington, J.M., K.M. Longshore, D.B. Thomson (2007). Quantifiying Landscape Ruggedness for Animal Habitat Anaysis: A case Study Using Bighorn Sheep inthe Mojave Desert. Journal of Wildlife Management. 71(5):1419-1426
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
