% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.time.series.R
\name{smooth.time.series}
\alias{smooth.time.series}
\title{Smooth Raster Time-series}
\usage{
smooth.time.series(x, f = 0.8, smooth.data = FALSE, ...)
}
\arguments{
\item{x}{A raster stack or brick class object}

\item{f}{Smoothing parameter (see loess span argument)}

\item{smooth.data}{(FALSE/TRUE) Smooth all of the data or just impute NA values}

\item{...}{Additional arguments passed to raster calc (for writing results to disk)}
}
\value{
A raster stack or brick object with imputed NA values or smoothed data.
}
\description{
Smooths pixel-level data in raster time-series and can impute missing (NA) values.
}
\details{
This function uses a LOESS regression to smooth the time-series (using the smooth.data = TRUE argument). 
If the data is smoothed, it will be replaced by a loess estimate of the time-series (estimated distribution 
at the pixel-level). The results can dramatically be effected by the choice of the smoothing parameter (f) 
so caution is warranted and the effect of this parameter tested. Alternately, with smooth.data = FALSE,
the function can be used to impute missing pixel data (NA) in raster time-series (stacks/bricks).
}
\examples{
\dontrun{
 # fill NA values
 lai.new <- smooth.time.series(lai)  

 # Smooth time-series with a relaxed smoothing parameter
 lai.smooth <- smooth.time.series(lai, f = 0.2, smooth.data = TRUE)  
}

}
\seealso{
\code{\link[stats]{loess}} for details on the loess regression

\code{\link[raster]{calc}} for details on additional (...) arguments
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
