% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_data.R
\name{filter_data}
\alias{filter_data}
\title{filter_data: Filters cells/spots, genes, or samples}
\usage{
filter_data(
  x = NULL,
  spot_minreads = 0,
  spot_maxreads = NULL,
  spot_mingenes = 0,
  spot_maxgenes = NULL,
  spot_minpct = 0,
  spot_maxpct = NULL,
  gene_minreads = 0,
  gene_maxreads = NULL,
  gene_minspots = 0,
  gene_maxspots = NULL,
  gene_minpct = 0,
  gene_maxpct = NULL,
  samples = NULL,
  rm_tissue = NULL,
  rm_spots = NULL,
  rm_genes = NULL,
  rm_genes_expr = NULL,
  spot_pct_expr = "^MT-"
)
}
\arguments{
\item{x}{an STlist}

\item{spot_minreads}{the minimum number of total reads for a spot to be retained}

\item{spot_maxreads}{the maximum number of total reads for a spot to be retained}

\item{spot_mingenes}{the minimum number of non-zero counts for a spot to be retained}

\item{spot_maxgenes}{the maximum number of non-zero counts for a spot to be retained}

\item{spot_minpct}{the minimum percentage of counts for features defined by \code{spot_pct_expr} for a spot to be retained.}

\item{spot_maxpct}{the maximum percentage of counts for features defined by \code{spot_pct_expr} for a spot to be retained.}

\item{gene_minreads}{the minimum number of total reads for a gene to be retained}

\item{gene_maxreads}{the maximum number of total reads for a gene to be retained}

\item{gene_minspots}{he minimum number of spots with non-zero counts for a gene to be retained}

\item{gene_maxspots}{the maximum number of spots with non-zero counts for a gene to be retained}

\item{gene_minpct}{the minimum percentage of spots with non-zero counts for a gene to be retained}

\item{gene_maxpct}{the maximum percentage of spots with non-zero counts for a gene to be retained}

\item{samples}{samples (as in \code{names(x@counts)}) to perform filtering.}

\item{rm_tissue}{sample (as in \code{names(x@counts)}) to remove from STlist. Removes samples in \code{x@counts}, \code{x@tr_counts}, \code{x@spatial_meta}, \code{x@gene_meta}, and \code{x@sample_meta}}

\item{rm_spots}{vector of spot/cell IDs to remove. Removes spots/cells in \code{x@counts}, \code{x@tr_counts}, and \code{x@spatial_meta}}

\item{rm_genes}{vector of gene names to remove from STlist. Removes genes in \code{x@counts}, \code{x@tr_counts}, and \code{x@gene_meta}}

\item{rm_genes_expr}{a regular expression that matches genes to remove. Removes genes in \code{x@counts}, \code{x@tr_counts}, and \code{x@gene_meta}}

\item{spot_pct_expr}{a expression to use with \code{spot_minpct} and \code{spot_maxpct}. By default '^MT-'.}
}
\value{
an STlist containing the filtered data
}
\description{
Filtering of spots/cells, genes or samples, as well as count-based
filtering
}
\details{
This function provides options to filter elements in an STlist. It can remove
cells/spots or genes based on raw counts (\code{x@counts}). Users can input an
regular expression to query gene names and calculate percentages (for example \%
mtDNA genes). The function also can filter entire samples. Note that the function
removes cells/spots, genes, and/or samples in the raw counts, transformed counts,
spatial variables, gene variables, and sample metadata. Also note that the function
filters in the following order:
\enumerate{
\item Samples (\code{rm_tissue})
\item Spots (\code{rm_spots})
\item Genes (\code{rm_genes})
\item Genes matching \code{rm_genes_expr}
\item Min and max counts
}
}
\examples{

# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
unzip(zipfile=zip_tmp, exdir=thrane_tmp)
# Generate the file paths to be passed to the STlist function
count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='counts')
coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='mapping')
clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                       full.names=TRUE, pattern='clinical')
# Create STlist
library('spatialGE')
melanoma <- STlist(rnacounts=count_files[c(1,2)],
                   spotcoords=coord_files[c(1,2)],
                   samples=clin_file) # Only first two samples
melanoma <- filter_data(melanoma, spot_minreads=2000)

}
