% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dixons_s.R
\name{dixons_s}
\alias{dixons_s}
\title{Dixon's S Segregation Statistic}
\usage{
dixons_s(
  mif,
  mnames,
  num_permutations = 1000,
  type = c("Z", "C"),
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL
)
}
\arguments{
\item{mif}{An MIF object}

\item{mnames}{vector of markers corresponding to spatial columns to check Dixon's S between}

\item{num_permutations}{Numeric value indicating the number of permutations used. 
Default is 1000.}

\item{type}{a character string for the type that is wanted in the output which can
be "Z" for z-statistic results or "C" for Chi-squared statistic results}

\item{workers}{Integer value for the number of workers to spawn}

\item{overwrite}{Logical value determining if you want the results to replace the 
current output (TRUE) or be to be appended (FALSE).}

\item{xloc}{a string corresponding to the x coordinates. If null the average of 
XMin and XMax will be used}

\item{yloc}{a string corresponding to the y coordinates. If null the average of 
YMin and YMax will be used}
}
\value{
Returns a data frame for Z-statistic
   \item{From}{}
   \item{To}{}
   \item{Obs.Count}{}
   \item{Exp. Count}{}
   \item{S}{}
   \item{Z}{}
   \item{p-val.Z}{}
   \item{p-val.Nobs}{}
   \item{Marker}{}
   \item{Classifier Labeled Column Counts}{}
   \item{Image.Tag}{}

Returns a data frame for C-statistic
   \item{Segregation}{}
   \item{df}{}
   \item{Chi-sq}{}
   \item{P.asymp}{}
   \item{P.rand}{}
   \item{Marker}{}
   \item{Classifier Labeled Column Counts}{}
   \item{Image.Tag}{}
}
\description{
This function processes the spatial files in the mif object,
requiring a column that distinguishes between different groups i.e. tumor and 
stroma
}
\examples{
#' #Create mif object
library(dplyr)
x <- create_mif(clinical_data = example_clinical \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
sample_data = example_summary \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
spatial_list = example_spatial,
patient_id = "deidentified_id", 
sample_id = "deidentified_sample")

}
