% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label}
\alias{label}
\alias{percolation}
\title{Labelling of unique patches and detection of percolation.}
\usage{
label(mat, nbmask = "von_neumann", wrap = FALSE)

percolation(mat, nbmask = "von_neumann")
}
\arguments{
\item{mat}{A binary matrix}

\item{nbmask}{Either "moore" for 8-way neighborhood, "von_neumann" for four-way 
neighborhood (default), or a 3x3 matrix describing which neighbors to 
consider around a cell. See \code{\link{patchsizes}} for details on how to specify 
such neighborhoods.}

\item{wrap}{Whether to wrap around lattice boundaries (`TRUE`/`FALSE`), 
effectively using periodic boundaries.}
}
\value{
A matrix containing ID numbers for each connected patch. Default 
  parameters assume 4-cell neighborhood and periodic boundaries. The 
  distribution of patch sizes is returned as the attribute "psd" and the 
  percolation status as "percolation" (whether a TRUE patch has a width 
  or height equal to the size of the matrix).
}
\description{
Label each patch with a number in a binary matrix

\code{percolation()} detects whether percolation occurs in the
  matrix (i.e. a patch has a width or a height equal to the size of the 
  matrix)
}
\details{
The \code{label} function "labels" the patches of a binary 
  (\code{TRUE}/\code{FALSE}) matrix. It returns a matrix of similar height and width, 
  with integer values representing the ID of each unique patch (contiguous
   cells). Empty cells are labelled as \code{NA}.
}
\examples{

data(forestgap)

rmat <- matrix(rnorm(100) > .1, ncol = 10)
display_matrix(label(rmat))

# With 8-way neighborhood mask and no wrapping around borders
display_matrix(label(rmat, "moore", wrap = FALSE))

# On real data: 
display_matrix(label(forestgap[[5]], "moore", wrap = FALSE))

}
\seealso{
\code{\link{patchsizes}}, \code{\link{patchdistr_sews}}
}
