% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/shewhart.R
\docType{methods}
\name{getcdfupdates}
\alias{getcdfupdates}
\alias{getcdfupdates,SPCShew-method}
\alias{getcdfupdates,SPCchart-method}
\title{CDF of Updates of a Control Chart}
\usage{
getcdfupdates(chart, P, xi)

\S4method{getcdfupdates}{SPCchart}(chart, P, xi)

\S4method{getcdfupdates}{SPCShew}(chart, P, xi)
}
\arguments{
\item{chart}{the chart to be used.}

\item{P}{the probability model from which data is generated.}

\item{xi}{the parameters of the control chart.}
}
\value{
A function mapping one-dimensional numerical values into
the interval [0,1], having all properties of a cumulative
distribution function.
}
\description{
Consider running a control chart with given parameters with data
coming from a given probability model. This function computes the
cumulative distribution function (CDF) of the updates of the
control charts as they would be computed by the method \code{\link{updates}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{SPCchart}: Standard method which simply first applies
getcdfresiduals from the data model.

\item \code{SPCShew}: Computes the CDF of the updates taking
into account if the chart is one-sided or two-sided.
}}

