% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dohCluster.R
\name{dohCluster}
\alias{dohCluster}
\title{CluPA function for multiple spectra.}
\usage{
dohCluster(X, peakList, refInd = 0, maxShift = 100, acceptLostPeak = TRUE,
  verbose = TRUE)
}
\arguments{
\item{X}{The spectral dataset in the matrix format in which each row contains a single sample}

\item{peakList}{The peak lists of the spectra}

\item{refInd}{The index of the reference spectrum.}

\item{maxShift}{The maximum number of the points for a shift step.}

\item{acceptLostPeak}{This is an option for users, TRUE is the default value. If the users believe that all the peaks in the peak list are true positive, change it to FALSE.}

\item{verbose}{A boolean value to allow print out process information.}
}
\value{
The aligned spectra.
}
\description{
Use CluPA for alignment for multiple spectra.
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
peakList <- detectSpecPeaks(X,
                            nDivRange = c(128),
                            scales = seq(1, 16, 2),
                            baselineThresh = 50000,
                            SNR.Th = -1,
                            verbose=FALSE
);
resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;
maxShift = 50;
Y <- dohCluster(X,
                peakList = peakList,
                refInd = refInd,
                maxShift  = maxShift,
                acceptLostPeak = TRUE, verbose=FALSE);

}
\seealso{
\code{\link{dohClusterCustommedSegments}}
}
\author{
Trung Nghia Vu
}
