% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SilhouetR.R
\name{SilhouetR}
\alias{SilhouetR}
\title{SilhouetR}
\usage{
SilhouetR(DataMatrix, GroupIndices, distance = "euclid", stand = TRUE)
}
\arguments{
\item{DataMatrix}{a matrix with the raw data, 1 variable per column.}

\item{GroupIndices}{The vector with the roup indices (length must be equal to the amount of rwos in DataMatrix).}

\item{distance}{The distance metric to be used, see \link[cluster]{daisy}.}

\item{stand}{whether to standardize the data before calculating the dissimilarities. See \link[cluster]{daisy}.}
}
\value{
Returns the silhouette values.
}
\description{
Calculate the Silhouette value for
}
\examples{
\dontrun{
# This function works on aligned peak data
library(ggplot2)
Silhouette.values = SilhouetR(DataMatrix = Aligned.peaks$peakPPM, 
Aligned.peaks$peakIndex, distance = 'euclid', stand = TRUE)
ggplot(SilhouetteValues, aes(SilhouetteValues)) +geom_freqpoly(binwidth = 0.03) +theme_bw()
}

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}

