% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decisiontree.r
\name{plot_decisiontree}
\alias{plot_decisiontree}
\title{Plot decision tree}
\usage{
plot_decisiontree(df, label = FALSE, legend = FALSE)
}
\arguments{
\item{df}{data frame resulting from \code{\link[=run_specs]{run_specs()}}.}

\item{label}{Logical. Should labels be included? Defaults to FALSE. Produces only a reasonable plot if number of specifications is low.}

\item{legend}{Logical. Should specific decisions be identifiable. Defaults to FALSE.}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
This function plots a simple decision tree that is meant to help understanding how few analytical choices may results in a large number of specifications. It is somewhat useless if the final number of specifications is very high.
}
\examples{
results <- run_specs(df = example_data,
                    y = c("y1", "y2"),
                    x = c("x1", "x2"),
                    model = c("lm"),
                    controls = c("c1", "c2"))

# Basic, non-labelled decisions tree
plot_decisiontree(results)

# Labelled decisions tree
plot_decisiontree(results, label = TRUE)

# Add legend
plot_decisiontree(results, label = TRUE, legend = TRUE)
}
