% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{apply_spectra}
\alias{apply_spectra}
\title{Apply a function on the spectra of a Spectra* object}
\usage{
apply_spectra(obj, fun, ...)
}
\arguments{
\item{obj}{an object inheriting from class \code{Spectra}}

\item{fun}{an aggregation function}

\item{...}{expressions evaluated in the context of \code{fun}}
}
\value{
An object of the same class as \code{obj}
}
\description{
Aggregates spectral and data information of a \code{Spectra} object using a
user-defined function.

Apply a function and update the spectra of a \code{Spectra} object. This
function is particularly interesting for pre-processing, e.g to derive the
spectra, or apply pre-processing functions such as \code{snv}.
}
\details{
The philosophy of this function is to let the user free to use any function
to pre-process a spectra collection, using either functions from the stats
package, functions from other packages such as \code{signal}, or personal
functions.
}
\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Second derivative
r <- apply_spectra(australia, diff, 2)
plot(r)

# Smoothing kernel
k <- kernel("daniell", 20) # define a kernel
r <- apply_spectra(australia, kernapply, k)
plot(r)

\dontrun{
# Savitzky-Golay filter (from the signal package)
library(signal)
r <- apply_spectra(australia, sgolayfilt, n = 33, p = 4)
plot(r)
}

}
\seealso{
\code{\link{aggregate_spectra}}, \code{\link{snv}},
\code{\link{rnv}}
}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
