% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/spectralPreprocessing.R
\docType{methods}
\name{smooth}
\alias{smooth}
\alias{smooth,SpectraInTime-method}
\title{generic smoothing function}
\usage{
smooth(object, ...)

\S4method{smooth}{SpectraInTime}(object, method = "sg", order = 3,
  window = order + 3 - order\%\%2, derivative = 0)
}
\arguments{
\item{object}{a S4 class object}

\item{...}{additional parameters}

\item{method}{character vector smoothing method, default = 'sg', i.e Savitsky-Golay filter.
currently only implemented smoothing method}

\item{order}{numeric value,  order of the polynomial used to interpolate, should be larger than derivative order,
defaults to 3 + derivative}

\item{window}{width of the smoothing}

\item{derivative}{derivative to be taken, defaults to \code{0}}
}
\description{
generic smoothing function

smoothing is applied in the wavelength domain, not in the time domain
}
\note{
equal distances between wavelenght intervals are assumed
}
\examples{
     spectralEx     <-  getSpectraInTimeExample()
    smoothDefault   <-  smooth( spectralEx )
    timeRange       <-  range( getTimePoints( spectralEx ))
    timesToSelect   <-  e( seq( timeRange[1] , timeRange[2] , length.out = 5  )  )
    # plot( smoothDefault  )
    # plot( smoothDefault[ timesToSelect , ] , type = "time")
    smoothALot      <-  smooth( spectralEx ,  order = 2 , window = 301  ) 
    # plot( smoothALot )
    # plot( smoothALot[  timesToSelect , ] , type = "time" )
    derivative1     <-  smooth( spectralEx , derivative = 1 )
    # plot( derivative1 )
    # plot( derivative1[  timesToSelect ,] , type = "time" )
    
    derivative2     <-  smooth( spectralEx , derivative = 2 )
    # plot(  derivative2 )
    # plot( derivative2[  timesToSelect , ] , type = "time" )
    
}
