% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{combine}
\alias{combine}
\alias{combine.spectra}
\title{Combine spectral datasets}
\usage{
combine(s1, s2)

\method{combine}{spectra}(s1, s2)
}
\arguments{
\item{s1}{spectra object 1}

\item{s2}{spectra object 2}
}
\value{
combined spectra object
}
\description{
\code{combine} binds two spectral datasets. Both spectra must have the
very same wavelength labels, but different metadata are acceptable
}
\section{Methods (by class)}{
\itemize{
\item \code{spectra}: Combines two spectral datasets
}}

\examples{
library(spectrolab)

# Create dummy spectra datasets. Pretend that these are all different...
s1 = as.spectra(spec_matrix_example, name_idx = 1)
s2 = as.spectra(spec_matrix_example, name_idx = 1)
s3 = as.spectra(spec_matrix_example, name_idx = 1)

# combine 2 spectra objects
s_1and2 = combine(s1, s2)

# combine n spectra objects using the `Reduce` function
s_n = Reduce(combine, list(s1, s2, s3))
}
\author{
Jose Eduardo Meireles
}
