/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.ArchGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.EclipseDockTitleEvent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class DockTitleTab
implements TabComponent {
    public static final TabPainter FACTORY = DockTitleTab.createFactory(ArchGradientPainter.FACTORY);
    private DockStation station;
    private Dockable dockable;
    private DockTitleRequest title;
    private TabPlacement placement;
    private JPanel content;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private boolean focused;
    private boolean selected;
    private boolean paintIconWhenInactive;
    private MouseInputListener mouseListener = new MouseInputListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                mouseListener.mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                mouseListener.mouseExited(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                mouseListener.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                mouseListener.mouseReleased(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            for (MouseMotionListener mouseMotionListener : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                mouseMotionListener.mouseDragged(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            for (MouseMotionListener mouseMotionListener : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                mouseMotionListener.mouseMoved(mouseEvent);
            }
        }
    };

    public static final TabPainter createFactory(final TabPainter tabPainter) {
        return new TabPainter(){

            public TabComponent createTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable) {
                DockTitleVersion dockTitleVersion;
                DockStation dockStation = eclipseTabPane.getStation();
                DockController dockController = dockStation.getController();
                DockTitleVersion dockTitleVersion2 = dockTitleVersion = dockController == null ? null : dockController.getDockTitleManager().getVersion("eclipse.tab");
                if (dockTitleVersion == null) {
                    return tabPainter.createTabComponent(eclipseTabPane, dockable);
                }
                eclipseTabPane.setContentBorderAt(eclipseTabPane.indexOf(dockable), null);
                return new DockTitleTab(dockStation, dockable, dockTitleVersion);
            }

            public InvisibleTab createInvisibleTab(InvisibleTabPane invisibleTabPane, Dockable dockable) {
                return tabPainter.createInvisibleTab(invisibleTabPane, dockable);
            }

            public TabPanePainter createDecorationPainter(EclipseTabPane eclipseTabPane) {
                return tabPainter.createDecorationPainter(eclipseTabPane);
            }

            public Border getFullBorder(BorderedComponent borderedComponent, DockController dockController, Dockable dockable) {
                return BorderFactory.createLineBorder((Color)dockController.getColors().get("stack.border"));
            }
        };
    }

    public DockTitleTab(DockStation dockStation, final Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.content = new JPanel(new BorderLayout());
        this.content.setOpaque(false);
        this.station = dockStation;
        this.dockable = dockable;
        this.title = new DockTitleRequest(dockStation, dockable, dockTitleVersion){

            protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                if (dockTitle != null) {
                    DockTitleTab.this.content.removeAll();
                    dockable.unbind(dockTitle);
                    dockTitle.removeMouseInputListener(DockTitleTab.this.mouseListener);
                }
                if (dockTitle2 != null) {
                    dockable.bind(dockTitle2);
                    dockTitle2.addMouseInputListener(DockTitleTab.this.mouseListener);
                    DockTitleTab.this.updateOrientation();
                    DockTitleTab.this.content.add(dockTitle2.getComponent(), "Center");
                    DockTitleTab.this.fire();
                }
            }
        };
    }

    public void setOrientation(TabPlacement tabPlacement) {
        this.placement = tabPlacement;
        this.updateOrientation();
    }

    private void updateOrientation() {
        DockTitle dockTitle = this.title.getAnswer();
        if (this.placement != null && dockTitle != null) {
            switch (this.placement) {
                case TOP_OF_DOCKABLE: {
                    dockTitle.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    dockTitle.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    dockTitle.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    dockTitle.setOrientation(DockTitle.Orientation.EAST_SIDED);
                }
            }
        }
    }

    public void bind() {
        this.title.install();
        this.title.request();
        this.fire();
    }

    public void unbind() {
        this.title.uninstall();
        this.title.requestNull();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.add(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.add(mouseMotionListener);
    }

    public Component getComponent() {
        return this.content;
    }

    public Dimension getMinimumSize(TabComponent[] tabComponentArray) {
        return this.getComponent().getMinimumSize();
    }

    public Dimension getPreferredSize(TabComponent[] tabComponentArray) {
        return this.getComponent().getPreferredSize();
    }

    public DockElement getElement() {
        return this.title.getTarget();
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public Point getPopupLocation(Point point, boolean bl) {
        DockTitle dockTitle = this.title.getAnswer();
        if (dockTitle == null) {
            return null;
        }
        return dockTitle.getPopupLocation(point, bl);
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseListeners.add(mouseInputListener);
        this.mouseMotionListeners.add(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseListeners.remove(mouseInputListener);
        this.mouseMotionListeners.remove(mouseInputListener);
    }

    public Insets getOverlap(TabComponent tabComponent) {
        return new Insets(0, 0, 0, 0);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.remove(mouseMotionListener);
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
        this.fire();
    }

    public void setPaintIconWhenInactive(boolean bl) {
        this.paintIconWhenInactive = bl;
        this.fire();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.fire();
    }

    public void setIcon(Icon icon) {
    }

    public void setText(String string) {
    }

    public void setTooltip(String string) {
    }

    public void update() {
        this.fire();
    }

    protected void fire() {
        DockTitle dockTitle = this.title.getAnswer();
        if (dockTitle != null) {
            EclipseDockTitleEvent eclipseDockTitleEvent = new EclipseDockTitleEvent(this.station, this.dockable, this.selected, this.focused, this.paintIconWhenInactive);
            dockTitle.changed(eclipseDockTitleEvent);
        }
    }
}

