/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class HardBoundaryRestriction
implements BoundaryRestriction {
    public Rectangle check(ScreenDockWindow screenDockWindow) {
        return this.check(screenDockWindow, screenDockWindow.getWindowBounds());
    }

    public Rectangle check(ScreenDockWindow screenDockWindow, Rectangle rectangle) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        double d = -1.0;
        GraphicsDevice graphicsDevice = null;
        for (GraphicsDevice graphicsDevice2 : graphicsDeviceArray) {
            double d2 = this.measureBounds(screenDockWindow, n, n2, n3, n4, graphicsDevice2);
            if (!(d2 > d)) continue;
            d = d2;
            graphicsDevice = graphicsDevice2;
        }
        if (graphicsDevice == null) {
            return null;
        }
        return this.boundsInDevice(screenDockWindow, n, n2, n3, n4, graphicsDevice);
    }

    protected double measureBounds(ScreenDockWindow screenDockWindow, int n, int n2, int n3, int n4, GraphicsDevice graphicsDevice) {
        if (n3 == 0 || n4 == 0) {
            return 0.0;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(screenDockWindow);
        if (graphicsConfiguration == null) {
            return 0.0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Rectangle rectangle2 = new Rectangle(n + rectangle.x, n2 + rectangle.y, n3, n4);
        rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            return 0.0;
        }
        return (double)(rectangle3.width * rectangle3.height) / ((double)rectangle2.width * (double)rectangle2.height);
    }

    protected Rectangle boundsInDevice(ScreenDockWindow screenDockWindow, int n, int n2, int n3, int n4, GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(screenDockWindow);
        if (graphicsConfiguration != null) {
            Rectangle rectangle = graphicsConfiguration.getBounds();
            n += rectangle.x;
            n2 += rectangle.y;
            rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsDevice.getDefaultConfiguration());
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            n3 = Math.min(rectangle.width - insets.left - insets.right, n3);
            n4 = Math.min(rectangle.height - insets.top - insets.bottom, n4);
            n = Math.max(n, rectangle.x + insets.left);
            n2 = Math.max(n2, rectangle.y + insets.right);
            n = Math.min(n, rectangle.width - insets.left - insets.right - n3 + rectangle.x);
            n2 = Math.min(n2, rectangle.height - insets.top - insets.bottom - n4 + rectangle.y);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected GraphicsConfiguration getGraphicsConfiguration(ScreenDockWindow screenDockWindow) {
        Dockable dockable = screenDockWindow.getDockable();
        if (dockable == null) {
            return null;
        }
        Component component = dockable.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return null;
        }
        return window.getGraphicsConfiguration();
    }
}

