/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScreenDockProperty
extends AbstractDockableProperty {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean fullscreen;
    private Path placeholder;

    public String getFactoryID() {
        return "screen dock";
    }

    public ScreenDockProperty() {
    }

    public ScreenDockProperty(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public ScreenDockProperty(int n, int n2, int n3, int n4, Path path) {
        this(n, n2, n3, n4, path, false);
    }

    public ScreenDockProperty(int n, int n2, int n3, int n4, Path path, boolean bl) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.placeholder = path;
        this.fullscreen = bl;
    }

    public DockableProperty copy() {
        ScreenDockProperty screenDockProperty = new ScreenDockProperty(this.x, this.y, this.width, this.height, this.placeholder, this.fullscreen);
        this.copy(screenDockProperty);
        return screenDockProperty;
    }

    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.width);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeBoolean(this.fullscreen);
        dataOutputStream.writeBoolean(this.placeholder != null);
        if (this.placeholder != null) {
            dataOutputStream.writeUTF(this.placeholder.toString());
        }
    }

    public void store(XElement xElement) {
        xElement.addElement("x").setInt(this.x);
        xElement.addElement("y").setInt(this.y);
        xElement.addElement("width").setInt(this.width);
        xElement.addElement("height").setInt(this.height);
        xElement.addElement("fullscreen").setBoolean(this.fullscreen);
        if (this.placeholder != null) {
            xElement.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.width = dataInputStream.readInt();
        this.height = dataInputStream.readInt();
        this.fullscreen = false;
        this.placeholder = null;
        if (version.compareTo(Version.VERSION_1_0_8) >= 0) {
            this.fullscreen = dataInputStream.readBoolean();
            if (dataInputStream.readBoolean()) {
                this.placeholder = new Path(dataInputStream.readUTF());
            }
        }
    }

    public void load(XElement xElement) {
        XElement xElement2;
        this.x = xElement.getElement("x").getInt();
        this.y = xElement.getElement("y").getInt();
        this.width = xElement.getElement("width").getInt();
        this.height = xElement.getElement("height").getInt();
        this.fullscreen = false;
        this.placeholder = null;
        XElement xElement3 = xElement.getElement("fullscreen");
        if (xElement3 != null) {
            this.fullscreen = xElement3.getBoolean();
        }
        if ((xElement2 = xElement.getElement("placeholder")) != null) {
            this.placeholder = new Path(xElement2.getString());
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean bl) {
        this.fullscreen = bl;
    }

    public void setPlaceholder(Path path) {
        this.placeholder = path;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.fullscreen ? 1231 : 1237);
        n = 31 * n + this.height;
        n = 31 * n + (this.placeholder == null ? 0 : this.placeholder.hashCode());
        n = 31 * n + this.width;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScreenDockProperty screenDockProperty = (ScreenDockProperty)object;
        if (this.fullscreen != screenDockProperty.fullscreen) {
            return false;
        }
        if (this.height != screenDockProperty.height) {
            return false;
        }
        if (this.placeholder == null ? screenDockProperty.placeholder != null : !this.placeholder.equals(screenDockProperty.placeholder)) {
            return false;
        }
        if (this.width != screenDockProperty.width) {
            return false;
        }
        if (this.x != screenDockProperty.x) {
            return false;
        }
        return this.y == screenDockProperty.y;
    }
}

