/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenFullscreenAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    private ScreenDockStation screen;
    private DockController controller;
    private Listener listener = new Listener();
    private PropertyValue<KeyStroke> accelerator = new PropertyValue<KeyStroke>(SplitDockStation.MAXIMIZE_ACCELERATOR){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
            ScreenFullscreenAction.this.setAccelerator(Boolean.TRUE, keyStroke2);
            ScreenFullscreenAction.this.setAccelerator(Boolean.FALSE, keyStroke2);
        }
    };

    public ScreenFullscreenAction(ScreenDockStation screenDockStation) {
        super(null);
        this.screen = screenDockStation;
        this.setRemoveEmptyGroups(false);
        screenDockStation.addScreenDockStationListener(new ScreenDockStationListener(){

            public void windowRegistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            }

            public void windowDeregistering(ScreenDockStation screenDockStation, Dockable dockable, ScreenDockWindow screenDockWindow) {
            }

            public void fullscreenChanged(ScreenDockStation screenDockStation, Dockable dockable) {
                ScreenFullscreenAction.this.change(dockable, screenDockStation.isFullscreen(dockable));
            }
        });
        this.setText(Boolean.TRUE, DockUI.getDefaultDockUI().getString("screen.normalize"));
        this.setText(Boolean.FALSE, DockUI.getDefaultDockUI().getString("screen.maximize"));
        this.setTooltip(Boolean.TRUE, DockUI.getDefaultDockUI().getString("screen.normalize.tooltip"));
        this.setTooltip(Boolean.FALSE, DockUI.getDefaultDockUI().getString("screen.maximize.tooltip"));
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getIcons().remove("screen.normalize", this.listener);
                this.controller.getIcons().remove("screen.maximize", this.listener);
            }
            this.controller = dockController;
            this.accelerator.setProperties(dockController);
            if (dockController != null) {
                IconManager iconManager = dockController.getIcons();
                iconManager.add("screen.normalize", this.listener);
                iconManager.add("screen.maximize", this.listener);
                this.setIcon(true, iconManager.getIcon("screen.normalize"));
                this.setIcon(false, iconManager.getIcon("screen.maximize"));
            }
        }
    }

    @Override
    public void action(Dockable dockable) {
        while (dockable.getDockParent() != this.screen) {
            DockStation dockStation = dockable.getDockParent();
            if (dockStation == null) {
                return;
            }
            dockable = dockStation.asDockable();
            if (dockable != null) continue;
            return;
        }
        boolean bl = this.screen.isFullscreen(dockable);
        this.screen.setFullscreen(dockable, !bl);
    }

    private void change(Dockable dockable, Boolean bl) {
        DockStation dockStation;
        if (this.isKnown(dockable)) {
            this.setGroup(bl, dockable);
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = dockStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.change(dockStation.getDockable(i), bl);
            }
        }
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        while (dockable.getDockParent() != this.screen) {
            DockStation dockStation = dockable.getDockParent();
            if (dockStation == null) {
                return Boolean.FALSE;
            }
            dockable = dockStation.asDockable();
            if (dockable != null) continue;
            return Boolean.FALSE;
        }
        return this.screen.isFullscreen(dockable);
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            if (string.equals("screen.normalize")) {
                ScreenFullscreenAction.this.setIcon(true, icon);
            } else {
                ScreenFullscreenAction.this.setIcon(false, icon);
            }
        }
    }
}

