/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.CombinedStackDockContentPane;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPane;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombinedStackDockComponent<T extends CombinedTab, M extends CombinedMenu, I extends CombinedInfoComponent>
extends AbstractTabPane<T, M, I>
implements StackDockComponent {
    private CombinedStackDockContentPane panel;
    private Map<Dockable, Meta> components = new HashMap<Dockable, Meta>();
    private JPanel componentPanel = new JPanel(null){

        public void doLayout() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                this.getComponent(i).setBounds(0, 0, n, n2);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension dimension2 = this.getComponent(i).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension dimension2 = this.getComponent(i).getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
    };
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private CombinedHandler<CombinedTab> tabHandler = new CombinedHandler<CombinedTab>(){

        @Override
        public void setVisible(CombinedTab combinedTab, boolean bl) {
            DockController dockController = CombinedStackDockComponent.this.getController();
            if (bl) {
                CombinedStackDockComponent.this.panel.add(combinedTab.getComponent());
                if (dockController != null) {
                    dockController.addRepresentative(combinedTab);
                }
            } else {
                CombinedStackDockComponent.this.panel.remove(combinedTab.getComponent());
                if (dockController != null) {
                    dockController.removeRepresentative(combinedTab);
                }
            }
        }

        @Override
        public boolean isVisible(CombinedTab combinedTab) {
            return combinedTab.getComponent() != null && combinedTab.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedTab combinedTab, int n) {
            CombinedStackDockComponent.this.setZOrder(combinedTab.getComponent(), n);
        }

        @Override
        public int getZOrder(CombinedTab combinedTab) {
            return CombinedStackDockComponent.this.getZOrder(combinedTab.getComponent());
        }
    };
    private CombinedHandler<CombinedMenu> menuHandler = new CombinedHandler<CombinedMenu>(){

        @Override
        public void setVisible(CombinedMenu combinedMenu, boolean bl) {
            if (bl) {
                CombinedStackDockComponent.this.panel.add(combinedMenu.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(combinedMenu.getComponent());
            }
        }

        @Override
        public boolean isVisible(CombinedMenu combinedMenu) {
            return combinedMenu.getComponent() != null && combinedMenu.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedMenu combinedMenu, int n) {
            CombinedStackDockComponent.this.setZOrder(combinedMenu.getComponent(), n);
        }

        @Override
        public int getZOrder(CombinedMenu combinedMenu) {
            return CombinedStackDockComponent.this.getZOrder(combinedMenu.getComponent());
        }
    };
    private CombinedHandler<AbstractTabPaneComponent> infoHandler = new CombinedHandler<AbstractTabPaneComponent>(){

        @Override
        public void setVisible(AbstractTabPaneComponent abstractTabPaneComponent, boolean bl) {
            if (bl) {
                CombinedStackDockComponent.this.panel.add(abstractTabPaneComponent.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(abstractTabPaneComponent.getComponent());
            }
        }

        @Override
        public boolean isVisible(AbstractTabPaneComponent abstractTabPaneComponent) {
            return abstractTabPaneComponent.getComponent() != null && abstractTabPaneComponent.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(AbstractTabPaneComponent abstractTabPaneComponent, int n) {
            CombinedStackDockComponent.this.setZOrder(abstractTabPaneComponent.getComponent(), n);
        }

        @Override
        public int getZOrder(AbstractTabPaneComponent abstractTabPaneComponent) {
            return CombinedStackDockComponent.this.getZOrder(abstractTabPaneComponent.getComponent());
        }
    };

    public CombinedStackDockComponent() {
        this.panel = this.createContentPane(this);
        this.panel.add(this.componentPanel);
        this.addTabPaneListener(new TabPaneListener(){

            public void added(TabPane tabPane, Dockable dockable) {
            }

            public void removed(TabPane tabPane, Dockable dockable) {
            }

            public void selectionChanged(TabPane tabPane) {
                ChangeEvent changeEvent = new ChangeEvent(CombinedStackDockComponent.this);
                for (ChangeListener changeListener : CombinedStackDockComponent.this.listeners.toArray(new ChangeListener[CombinedStackDockComponent.this.listeners.size()])) {
                    changeListener.stateChanged(changeEvent);
                }
            }

            public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
            }
        });
    }

    protected CombinedStackDockContentPane createContentPane(CombinedStackDockComponent<T, M, I> combinedStackDockComponent) {
        return new CombinedStackDockContentPane(combinedStackDockComponent);
    }

    @Override
    public void revalidate() {
        this.panel.revalidate();
        this.repaint();
    }

    public void repaint() {
        this.panel.repaint();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    @Override
    public void setController(DockController dockController) {
        DockController dockController2 = this.getController();
        if (dockController2 != dockController) {
            List list = this.getTabsList();
            if (dockController2 != null) {
                for (CombinedTab combinedTab : list) {
                    dockController2.removeRepresentative(combinedTab);
                }
            }
            if (dockController != null) {
                for (CombinedTab combinedTab : list) {
                    dockController.addRepresentative(combinedTab);
                }
            }
            super.setController(dockController);
        }
    }

    public CombinedHandler<CombinedTab> getTabHandler() {
        return this.tabHandler;
    }

    public CombinedHandler<CombinedMenu> getMenuHandler() {
        return this.menuHandler;
    }

    public CombinedHandler<AbstractTabPaneComponent> getInfoHandler() {
        return this.infoHandler;
    }

    @Override
    public Rectangle getAvailableArea() {
        Insets insets = this.panel.getInsets();
        insets = insets == null ? new Insets(0, 0, 0, 0) : new Insets(insets.top, insets.left, insets.bottom, insets.right);
        return new Rectangle(insets.left, insets.top, Math.max(1, this.panel.getWidth() - insets.left - insets.right), Math.max(1, this.panel.getHeight() - insets.top - insets.bottom));
    }

    @Override
    public Rectangle getSelectedBounds() {
        return this.componentPanel.getBounds();
    }

    @Override
    public void setSelectedBounds(Rectangle rectangle) {
        this.componentPanel.setBounds(rectangle);
    }

    @Override
    public int getSelectedIndex() {
        return this.indexOf(this.getSelectedDockable());
    }

    @Override
    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.getDockableCount()) {
            this.setSelectedDockable(null);
        } else {
            this.setSelectedDockable(this.getDockable(n));
        }
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        if (this.getSelectedDockable() != dockable) {
            super.setSelectedDockable(dockable);
            for (Meta meta : this.components.values()) {
                meta.component.setVisible(meta.dockable == dockable);
            }
        }
    }

    @Override
    public Rectangle getBoundsAt(int n) {
        CombinedTab combinedTab = (CombinedTab)this.getTab(this.getDockable(n));
        if (combinedTab == null) {
            return null;
        }
        return combinedTab.getBounds();
    }

    @Override
    public int getTabCount() {
        return this.getDockableCount();
    }

    @Override
    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.insertTab(string, icon, component, dockable, this.getTabCount());
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        Component component2 = this.createLayerAt(component, dockable);
        Meta meta = new Meta(dockable, component2, string, icon, null);
        this.components.put(dockable, meta);
        this.componentPanel.add(component2);
        this.insert(n, dockable);
        meta.forward();
        meta.component.setVisible(this.getSelectedDockable() == dockable);
    }

    @Override
    public Dockable getDockableAt(int n) {
        return this.getDockable(n);
    }

    @Override
    public void moveTab(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n2 < 0 || n2 >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.getSelectedIndex();
        this.move(n, n2);
        if (n3 == n) {
            n3 = n2;
        } else if (n3 > n && n3 <= n2) {
            ++n3;
        }
        this.setSelectedIndex(n3);
    }

    @Override
    public void remove(int n) {
        Dockable dockable = this.getDockable(n);
        super.remove(n);
        Meta meta = this.components.remove(dockable);
        this.componentPanel.remove(meta.component);
        meta.component.setVisible(true);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (Meta meta : this.components.values()) {
            this.componentPanel.remove(meta.component);
            meta.component.setVisible(true);
        }
        this.components.clear();
    }

    @Override
    public T putOnTab(Dockable dockable) {
        CombinedTab combinedTab = (CombinedTab)super.putOnTab(dockable);
        Meta meta = this.components.get(dockable);
        combinedTab.setIcon(meta.icon);
        combinedTab.setText(meta.text);
        combinedTab.setTooltip(meta.tooltip);
        return (T)combinedTab;
    }

    @Override
    protected void addToMenu(M m, Dockable dockable) {
        int n = m.getDockableCount();
        m.insert(n, dockable);
        Meta meta = this.components.get(dockable);
        m.setIcon(n, meta.icon);
        m.setText(n, meta.text);
        m.setTooltip(n, meta.tooltip);
    }

    @Override
    protected void removeFromMenu(M m, Dockable dockable) {
        m.remove(dockable);
    }

    protected Component createLayerAt(Component component, Dockable dockable) {
        return component;
    }

    public Component getLayerAt(int n) {
        return this.components.get((Object)this.getDockable((int)n)).component;
    }

    @Override
    public void setTitleAt(int n, String string) {
        Meta meta = this.components.get(this.getDockable(n));
        meta.text = string == null ? "" : string;
        meta.forward();
    }

    @Override
    public void setTooltipAt(int n, String string) {
        Meta meta = this.components.get(this.getDockable(n));
        meta.tooltip = string;
        meta.forward();
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        Meta meta = this.components.get(this.getDockable(n));
        meta.icon = icon;
        meta.forward();
    }

    @Override
    public void setComponentAt(int n, Component component) {
        Meta meta = this.components.get(this.getDockable(n));
        this.componentPanel.remove(meta.component);
        meta.component = this.createLayerAt(component, meta.dockable);
        this.componentPanel.add(meta.component);
        meta.component.setVisible(this.getSelectedDockable() == meta.dockable);
        this.revalidate();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    protected void setZOrder(Component component, int n) {
        this.panel.setComponentZOrder(component, n);
    }

    protected int getZOrder(Component component) {
        return this.panel.getComponentZOrder(component);
    }

    @Override
    public DockElementRepresentative createDefaultRepresentation(DockElement dockElement) {
        return new SimpleDockElementRepresentative(dockElement, this.panel);
    }

    private class Meta {
        public Dockable dockable;
        public Component component;
        public String text;
        public Icon icon;
        public String tooltip;

        public Meta(Dockable dockable, Component component, String string, Icon icon, String string2) {
            this.dockable = dockable;
            this.component = component;
            this.text = string;
            this.icon = icon;
            this.tooltip = string2;
        }

        public void forward() {
            CombinedTab combinedTab = (CombinedTab)CombinedStackDockComponent.this.getTab(this.dockable);
            if (combinedTab != null) {
                combinedTab.setIcon(this.icon);
                combinedTab.setText(this.text);
                combinedTab.setTooltip(this.tooltip);
            } else {
                CombinedMenu combinedMenu = (CombinedMenu)CombinedStackDockComponent.this.getMenu(this.dockable);
                if (combinedMenu != null) {
                    Dockable[] dockableArray = combinedMenu.getDockables();
                    for (int i = 0; i < dockableArray.length; ++i) {
                        if (dockableArray[i] != this.dockable) continue;
                        combinedMenu.setIcon(i, this.icon);
                        combinedMenu.setText(i, this.text);
                        combinedMenu.setTooltip(i, this.tooltip);
                        break;
                    }
                }
            }
        }
    }
}

