/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class UpdatingTitleMovingImage
implements MovingImage {
    private Dockable dockable;
    private JPanel content;
    private DockTitleVersion version;
    private DockTitleRequest request;
    private DockTitle.Orientation orientation;

    public UpdatingTitleMovingImage(Dockable dockable, DockTitleVersion dockTitleVersion, DockTitle.Orientation orientation) {
        if (dockable == null) {
            throw new IllegalArgumentException("ockable must not be null");
        }
        if (dockTitleVersion == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.dockable = dockable;
        this.content = new JPanel(new BorderLayout());
        this.content.setOpaque(false);
        this.version = dockTitleVersion;
        this.orientation = orientation;
    }

    public void bind() {
        this.request = new DockTitleRequest(null, this.dockable, this.version){

            protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                if (dockTitle != null) {
                    UpdatingTitleMovingImage.this.dockable.unbind(dockTitle);
                }
                UpdatingTitleMovingImage.this.content.removeAll();
                if (dockTitle2 != null) {
                    dockTitle2.setOrientation(UpdatingTitleMovingImage.this.orientation);
                    UpdatingTitleMovingImage.this.dockable.bind(dockTitle2);
                    UpdatingTitleMovingImage.this.content.add(dockTitle2.getComponent(), "Center");
                }
            }
        };
        this.request.install();
        this.request.request();
    }

    public Component getComponent() {
        return this.content;
    }

    public void unbind() {
        DockTitle dockTitle = this.request.getAnswer();
        if (dockTitle != null) {
            this.dockable.unbind(dockTitle);
            this.content.removeAll();
        }
        this.request.uninstall();
        this.request = null;
    }
}

