/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.AbstractDockableCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.title.DockTitleVersion;
import javax.swing.Icon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGridArea
extends AbstractDockableCStation<SplitDockStation>
implements SingleCDockable {
    private String uniqueId;
    private SplitDockStation station;
    private SplitResizeRequestHandler resizeRequestHandler;
    private CSplitDockStationHandle modeManagerHandle;
    private boolean maximizing = false;

    public CGridArea(CControl cControl, String string) {
        this.init(cControl, string);
    }

    protected CGridArea() {
    }

    protected void init(CControl cControl, String string) {
        if (string == null) {
            throw new NullPointerException("id must not be null");
        }
        this.uniqueId = string;
        CommonStation<SplitDockStation> commonStation = cControl.getFactory().createSplitDockStation(new Delegate());
        this.station = commonStation.asDockStation();
        this.init(commonStation);
        this.setTitleShown(false);
        this.station.setExpandOnDoubleclick(false);
        this.resizeRequestHandler = new SplitResizeRequestHandler(this.station);
        this.setMaximizingArea(true);
        this.modeManagerHandle = new CSplitDockStationHandle(this, cControl.getLocationManager());
    }

    @Override
    protected CommonDockable createCommonDockable() {
        throw new IllegalStateException("the common-dockable gets already initialized by the constructor");
    }

    public void deploy(CGrid cGrid) {
        this.station.dropTree(cGrid.toTree());
    }

    @Override
    public SplitDockStation getStation() {
        return this.station;
    }

    @Override
    public CDockable asDockable() {
        return this;
    }

    public JComponent getComponent() {
        return this.station;
    }

    @Override
    public CLocation getStationLocation() {
        return new CGridAreaLocation(this);
    }

    public void setTitleText(String string) {
        this.station.setTitleText(string);
    }

    public String getTitleText() {
        return this.station.getTitleText();
    }

    public void setTitleIcon(Icon icon) {
        this.station.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.station.getTitleIcon();
    }

    public void setMaximizingArea(boolean bl) {
        if (bl != this.maximizing) {
            this.maximizing = bl;
            CControlAccess cControlAccess = this.getControl();
            if (cControlAccess != null) {
                CMaximizedMode cMaximizedMode = cControlAccess.getLocationManager().getMaximizedMode();
                if (this.maximizing) {
                    cMaximizedMode.add(this.modeManagerHandle.asMaximziedModeArea());
                } else {
                    cMaximizedMode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
                }
            }
        }
    }

    public boolean isMaximizingArea() {
        return this.maximizing;
    }

    @Override
    protected void install(CControlAccess cControlAccess) {
        cControlAccess.getLocationManager().getNormalMode().add(this.modeManagerHandle.asNormalModeArea());
        cControlAccess.getOwner().addResizeRequestListener(this.resizeRequestHandler);
        if (this.isMaximizingArea()) {
            CMaximizedMode cMaximizedMode = cControlAccess.getLocationManager().getMaximizedMode();
            cMaximizedMode.add(this.modeManagerHandle.asMaximziedModeArea());
        }
    }

    @Override
    protected void uninstall(CControlAccess cControlAccess) {
        cControlAccess.getLocationManager().getNormalMode().remove(this.modeManagerHandle.asNormalModeArea().getUniqueId());
        cControlAccess.getOwner().removeResizeRequestListener(this.resizeRequestHandler);
        if (this.isMaximizingArea()) {
            CMaximizedMode cMaximizedMode = cControlAccess.getLocationManager().getMaximizedMode();
            cMaximizedMode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
        }
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isExternalizable() {
        return false;
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public boolean isMinimizable() {
        return false;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    protected boolean suppressTitle(DockTitleVersion dockTitleVersion) {
        if (!this.isTitleShown()) {
            if (dockTitleVersion.getID().equals("split")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("flap window")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("screen dock")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("stack")) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Delegate
    implements CommonStationDelegate {
        private Delegate() {
        }

        @Override
        public CDockable getDockable() {
            return CGridArea.this;
        }

        @Override
        public DockActionSource[] getSources() {
            return new DockActionSource[]{CGridArea.this.getClose()};
        }

        public CStation<SplitDockStation> getStation() {
            return CGridArea.this;
        }

        @Override
        public boolean isTitleDisplayed(DockTitleVersion dockTitleVersion) {
            return !CGridArea.this.suppressTitle(dockTitleVersion);
        }
    }
}

