/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.facile.station.split.ResizeRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResizeElement<T> {
    private ResizeRequest request;
    private ResizeElement<T> parent;
    private LockedResizeLayoutManager<T> layout;

    public ResizeElement(ResizeElement<T> resizeElement, LockedResizeLayoutManager<T> lockedResizeLayoutManager) {
        this.parent = resizeElement;
        this.layout = lockedResizeLayoutManager;
    }

    public ResizeElement<T> getParent() {
        return this.parent;
    }

    public LockedResizeLayoutManager<T> getLayout() {
        return this.layout;
    }

    protected abstract ResizeRequest createRequest();

    public ResizeRequest getRequest() {
        return this.request;
    }

    protected abstract ResizeElement<T>[] getChildren();

    public void prepareResize() {
        ResizeElement<T>[] resizeElementArray = this.getChildren();
        if (resizeElementArray != null) {
            for (ResizeElement<T> resizeElement : resizeElementArray) {
                resizeElement.prepareResize();
            }
        }
    }

    public void prepareRequests() {
        ResizeElement<T>[] resizeElementArray = this.getChildren();
        if (resizeElementArray != null) {
            for (ResizeElement<T> resizeElement : resizeElementArray) {
                resizeElement.prepareRequests();
            }
        }
        this.request = this.createRequest();
    }

    public abstract void adapt(double var1, double var3);

    public ResizeRoot<T> getResizeRoot() {
        return this.parent.getResizeRoot();
    }
}

