/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.FlapResizeRequestHandler;
import bibliothek.gui.dock.common.location.CMinimizeAreaLocation;
import bibliothek.gui.dock.common.mode.CMinimizedModeArea;
import bibliothek.gui.dock.common.mode.station.CFlapDockStationHandle;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import java.awt.BorderLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMinimizeArea
extends JPanel
implements CStation<FlapDockStation> {
    private FlapDockStation station;
    private ResizeRequestListener request;
    private CControlAccess access;
    private String uniqueId;
    private CMinimizedModeArea area;

    public CMinimizeArea(CControl control, String uniqueId) {
        this.uniqueId = uniqueId;
        this.setLayout(new BorderLayout());
        this.station = control.getFactory().createFlapDockStation(this);
        this.request = new FlapResizeRequestHandler(this.station);
        this.add(this.station.getComponent(), "Center");
        this.setDirection(null);
        this.area = new CFlapDockStationHandle(this);
    }

    @Override
    public void setControl(CControlAccess access) {
        if (this.access != null) {
            this.access.getOwner().removeResizeRequestListener(this.request);
            this.access.getLocationManager().getMinimizedMode().remove(this.area.getUniqueId());
        }
        this.access = access;
        if (this.access != null) {
            this.access.getOwner().addResizeRequestListener(this.request);
            this.access.getLocationManager().getMinimizedMode().add(this.area);
        }
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public FlapDockStation getStation() {
        return this.station;
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CMinimizePerspective(this.getUniqueId());
    }

    @Override
    public CLocation getStationLocation() {
        return new CMinimizeAreaLocation(this);
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    @Override
    public CDockable asDockable() {
        return null;
    }

    public void setDirection(FlapDockStation.Direction direction) {
        if (direction == null) {
            this.station.setAutoDirection(true);
        } else {
            this.station.setAutoDirection(false);
            this.station.setDirection(direction);
        }
    }
}

