/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.predefined;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CDropDownItem;
import bibliothek.gui.dock.facile.action.CloseAction;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.KeyStroke;

public class CCloseAction
extends CDropDownItem {
    private CControl control;
    private PropertyValue<KeyStroke> keyClose = new PropertyValue<KeyStroke>(CControl.KEY_CLOSE){

        @Override
        protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
            CCloseAction.this.setAccelerator(newValue);
        }
    };

    public CCloseAction(CControl control) {
        super(null);
        if (control == null) {
            throw new NullPointerException("control is null");
        }
        this.control = control;
        this.init(new Action());
    }

    public void close(CDockable dockable) {
        if (dockable.isVisible()) {
            dockable.setVisible(false);
        }
    }

    @EclipseTabDockAction
    private class Action
    extends CloseAction {
        private int count;

        public Action() {
            super(null);
            this.count = 0;
        }

        protected void close(Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                CCloseAction.this.close(((CommonDockable)dockable).getDockable());
            } else {
                super.close(dockable);
            }
        }

        protected void bound(Dockable dockable) {
            super.bound(dockable);
            if (this.count == 0) {
                this.setController(CCloseAction.this.control.intern().getController());
                CCloseAction.this.keyClose.setProperties(CCloseAction.this.control.intern().getController());
            }
            ++this.count;
        }

        protected void unbound(Dockable dockable) {
            super.unbound(dockable);
            --this.count;
            if (this.count == 0) {
                this.setController(null);
                CCloseAction.this.keyClose.setProperties((DockProperties)null);
            }
        }
    }
}

