/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionDockBorder;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionBackgroundComponent;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBasicHandler<D extends DockAction, M extends BasicButtonModel>
implements BasicResourceInitializer {
    private D action;
    private M model;
    private Dockable dockable;
    private Background background = new Background();
    private Map<String, BorderHandle> borders = new HashMap<String, BorderHandle>();
    private boolean bound = false;

    public AbstractBasicHandler(D action, Dockable dockable) {
        if (action == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        this.dockable = dockable;
        this.action = action;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public D getAction() {
        return this.action;
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public void ensureBorder(BasicButtonModel model, String key) {
        this.addBorder(key);
    }

    public void addBorder(String key) {
        if (this.borders.get(key) == null) {
            BorderHandle handle = new BorderHandle(key);
            this.borders.put(key, handle);
            if (this.bound) {
                handle.setController(this.dockable.getController());
            }
        }
    }

    public void setModel(M model) {
        this.model = model;
        for (BorderHandle handle : this.borders.values()) {
            if (handle.modifier == null) continue;
            ((BasicButtonModel)model).setBorder(handle.id, handle.modifier);
        }
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            DockController controller = this.dockable.getController();
            this.background.setController(controller);
            for (BorderHandle handle : this.borders.values()) {
                handle.setController(controller);
            }
        }
    }

    public void unbind() {
        if (this.bound) {
            this.bound = false;
            this.background.setController(null);
            for (BorderHandle handle : this.borders.values()) {
                handle.setController(null);
            }
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    private class BorderHandle
    implements ActionDockBorder {
        private String id;
        private BorderModifier modifier;
        private DockController controller;

        public BorderHandle(String id) {
            this.id = id;
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = controller;
            if (this.controller == null) {
                this.set(null);
            } else {
                this.controller.getThemeManager().add(this.id, ActionDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            }
        }

        public void set(BorderModifier value) {
            if (this.modifier != value) {
                this.modifier = value;
                if (AbstractBasicHandler.this.model != null) {
                    AbstractBasicHandler.this.model.setBorder(this.id, value);
                }
            }
        }

        public DockAction getAction() {
            return AbstractBasicHandler.this.action;
        }

        public Dockable getDockable() {
            return AbstractBasicHandler.this.dockable;
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockActionBackgroundComponent {
        public Background() {
            super(DockActionBackgroundComponent.KIND, "dock.background.action");
        }

        public void set(BackgroundPaint value) {
            super.set(value);
            AbstractBasicHandler.this.model.setBackground(this.getPaint(), this);
        }

        public DockAction getAction() {
            return AbstractBasicHandler.this.action;
        }

        public Dockable getDockable() {
            return AbstractBasicHandler.this.dockable;
        }

        public Component getComponent() {
            return AbstractBasicHandler.this.model.getOwner();
        }
    }
}

