/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DropDownActionListener;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.AbstractBasicHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonTrigger;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.DropDownItemHandle;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDropDownButtonHandler
extends AbstractBasicHandler<DropDownAction, BasicDropDownButtonModel>
implements BasicDropDownButtonTrigger,
BasicTitleViewItem<JComponent> {
    private DockActionSource source;
    private Listener listener = new Listener();
    private DropDownItemHandle selection;
    private List<DockAction> actions = new ArrayList<DockAction>();
    private Map<DockAction, DropDownItemHandle> items = new HashMap<DockAction, DropDownItemHandle>();
    private JPopupMenu menu = new JPopupMenu();
    private SelectionView selectionView = new SelectionView();
    private ButtonView buttonView = new ButtonView();
    private DropDownFilter filter;

    public BasicDropDownButtonHandler(DropDownAction action, Dockable dockable) {
        super(action, dockable);
    }

    @Override
    public void bind() {
        DropDownAction action = (DropDownAction)this.getAction();
        Dockable dockable = this.getDockable();
        action.bind(dockable);
        this.filter = action.getFilter(dockable).createView(action, dockable, this.buttonView);
        this.filter.bind();
        this.source = action.getSubActions(dockable);
        int n = this.source.getDockActionCount();
        for (int i = 0; i < n; ++i) {
            DockAction sub = this.source.getDockAction(i);
            this.add(i, sub);
        }
        this.reset();
        this.selection = this.items.get(action.getSelection(dockable));
        if (this.selection != null) {
            this.selection.getView().setView(this.selectionView);
        }
        action.addDropDownActionListener(this.listener);
        action.addDockActionListener(this.listener);
        this.source.addDockActionSourceListener(this.listener);
        ((BasicDropDownButtonModel)this.getModel()).setEnabled(action.isEnabled(dockable));
        super.bind();
    }

    @Override
    public void unbind() {
        DropDownAction action = (DropDownAction)this.getAction();
        Dockable dockable = this.getDockable();
        action.removeDockActionListener(this.listener);
        action.removeDropDownActionListener(this.listener);
        this.source.removeDockActionSourceListener(this.listener);
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
        this.menu.removeAll();
        if (this.selection != null) {
            this.selection.getView().setView(null);
        }
        this.filter.unbind();
        this.filter = null;
        action.unbind(dockable);
        this.source = null;
        this.selection = null;
        this.items.clear();
        this.actions.clear();
        super.unbind();
        ((BasicDropDownButtonModel)this.getModel()).setDockableRepresentative(null);
    }

    @Override
    public void setBackground(Color background) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setBackground(background);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setForeground(foreground);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        ((BasicDropDownButtonModel)this.getModel()).setOrientation(orientation);
    }

    private void add(int index, DockAction action) {
        Dockable dockable = this.getDockable();
        this.actions.add(action);
        DropDownViewItem item = action.createView(ViewTarget.DROP_DOWN, dockable.getController().getActionViewConverter(), dockable);
        if (item != null) {
            DropDownItemHandle entry = new DropDownItemHandle(action, item, dockable, (DropDownAction)this.getAction());
            entry.bind();
            this.items.put(action, entry);
            this.menu.add((Component)item.getItem());
        }
    }

    private void remove(int index) {
        DockAction action = this.actions.remove(index);
        DropDownItemHandle item = this.items.remove(action);
        if (item != null) {
            item.unbind();
            this.menu.remove((Component)item.getView().getItem());
        }
    }

    @Override
    public JComponent getItem() {
        return ((BasicDropDownButtonModel)this.getModel()).getOwner();
    }

    @Override
    public void triggered() {
        BasicDropDownButtonModel model = (BasicDropDownButtonModel)this.getModel();
        if (model.isMouseOverDropDown()) {
            this.popupTriggered();
        } else if (this.selection == null || !model.isSelectionEnabled() || !this.selection.getView().isTriggerable(true)) {
            this.popupTriggered();
        } else if (this.selection.getView().isTriggerable(true)) {
            this.selection.getView().triggered();
        }
    }

    @Override
    public void popupTriggered() {
        BasicDropDownButtonModel model = (BasicDropDownButtonModel)this.getModel();
        JComponent button = model.getOwner();
        if (model.getOrientation().isHorizontal()) {
            this.menu.show(button, 0, button.getHeight());
        } else {
            this.menu.show(button, button.getWidth(), 0);
        }
    }

    public void updateUI() {
        if (this.menu != null) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    protected ButtonView getButtonView() {
        return this.buttonView;
    }

    protected void reset() {
        ((BasicDropDownButtonModel)this.getModel()).setSelectionEnabled(false);
        if (this.filter != null) {
            this.filter.setDisabledIcon(null);
            this.filter.setEnabled(true);
            this.filter.setIcon(null);
            this.filter.setSelected(false);
            this.filter.setText(null);
            this.filter.setTooltip(null);
            this.filter.setDockableRepresentation(null);
        }
        this.update();
    }

    protected void update() {
        if (this.filter != null) {
            this.filter.update(this.selection == null ? null : this.selection.getView());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements StandardDockActionListener,
    DropDownActionListener,
    DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicDropDownButtonHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setEnabled(action.isEnabled(dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(BasicDropDownButtonHandler.this.getDockable())) {
                BasicDropDownButtonHandler.this.update();
            }
        }

        @Override
        public void selectionChanged(DropDownAction action, Set<Dockable> dockables, DockAction newSelection) {
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(null);
            }
            BasicDropDownButtonHandler.this.reset();
            BasicDropDownButtonHandler.this.selection = (DropDownItemHandle)BasicDropDownButtonHandler.this.items.get(newSelection);
            if (BasicDropDownButtonHandler.this.selection != null) {
                BasicDropDownButtonHandler.this.selection.getView().setView(BasicDropDownButtonHandler.this.selectionView);
            }
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).changed();
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                BasicDropDownButtonHandler.this.add(i, source.getDockAction(i));
            }
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            for (int i = lastIndex; i >= firstIndex; --i) {
                BasicDropDownButtonHandler.this.remove(i);
            }
        }
    }

    protected class ButtonView
    implements DropDownView {
        protected ButtonView() {
        }

        public void setDisabledIcon(Icon icon) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setDisabledIcon(icon);
        }

        public void setEnabled(boolean enabled) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelectionEnabled(enabled);
        }

        public void setIcon(Icon icon) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setIcon(icon);
        }

        public void setSelected(boolean selected) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelected(selected);
        }

        public void setText(String text) {
        }

        public void setTooltip(String tooltip) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setToolTipText(tooltip);
        }

        public void setDockableRepresentation(Dockable dockable) {
            if (BasicDropDownButtonHandler.this.isBound()) {
                ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setDockableRepresentative(dockable);
            }
        }
    }

    protected class SelectionView
    implements DropDownView {
        protected SelectionView() {
        }

        public void setEnabled(boolean enabled) {
            ((BasicDropDownButtonModel)BasicDropDownButtonHandler.this.getModel()).setSelectionEnabled(enabled);
            BasicDropDownButtonHandler.this.filter.setEnabled(enabled);
            BasicDropDownButtonHandler.this.update();
        }

        public void setIcon(Icon icon) {
            BasicDropDownButtonHandler.this.filter.setIcon(icon);
            BasicDropDownButtonHandler.this.update();
        }

        public void setDisabledIcon(Icon icon) {
            BasicDropDownButtonHandler.this.filter.setDisabledIcon(icon);
            BasicDropDownButtonHandler.this.update();
        }

        public void setSelected(boolean selected) {
            BasicDropDownButtonHandler.this.filter.setSelected(selected);
            BasicDropDownButtonHandler.this.update();
        }

        public void setText(String text) {
            BasicDropDownButtonHandler.this.filter.setText(text);
            BasicDropDownButtonHandler.this.update();
        }

        public void setTooltip(String tooltip) {
            BasicDropDownButtonHandler.this.filter.setTooltip(tooltip);
            BasicDropDownButtonHandler.this.update();
        }

        public void setDockableRepresentation(Dockable dockable) {
            BasicDropDownButtonHandler.this.filter.setDockableRepresentation(dockable);
            BasicDropDownButtonHandler.this.update();
        }
    }
}

