/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.laf;

import bibliothek.gui.dock.util.laf.AbstractLookAndFeelColors;
import java.awt.Color;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class Nimbus6u10
extends AbstractLookAndFeelColors {
    private Map<String, String> translations = new HashMap<String, String>();
    private Listener listener = new Listener();

    public Nimbus6u10() {
        this.translations.put("dock.title.background", "menu");
        this.translations.put("dock.title.foreground", "menuText");
        this.translations.put("dock.title.selection.background", "nimbusSelection");
        this.translations.put("dock.title.selection.foreground", "menu");
        this.translations.put("dock.selection.background", "nimbusSelectionBackground");
        this.translations.put("dock.background", "control");
        this.translations.put("dock.foreground", "text");
        this.translations.put("dock.control.shadow", "controlDkShadow");
        this.translations.put("dock.window.border", "windowBorder");
    }

    public Color getColor(String key) {
        if ((key = this.translations.get(key)) == null) {
            return null;
        }
        Color color = UIManager.getColor(key);
        if (color == null) {
            return null;
        }
        return new Color(color.getRGB());
    }

    public void bind() {
        UIManager.addPropertyChangeListener(this.listener);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Nimbus6u10.this.fireColorsChanged();
            }
        });
    }

    public void unbind() {
        UIManager.removePropertyChangeListener(this.listener);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            this.update(name);
        }

        public void update(String name) {
            for (Map.Entry entry : Nimbus6u10.this.translations.entrySet()) {
                if (!((String)entry.getValue()).equals(name)) continue;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Nimbus6u10.this.fireColorsChanged();
                    }
                });
                return;
            }
        }
    }
}

