/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.event;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.CDockable;

public class CDockableLocationEvent {
    private CDockable dockable;
    private boolean oldVisible;
    private boolean newVisible;
    private boolean locationChanged;
    private CLocation oldLocation;
    private CLocation newLocation;

    public CDockableLocationEvent(CDockable dockable, boolean oldVisible, boolean newVisible, CLocation oldLocation, CLocation newLocation) {
        this.dockable = dockable;
        this.oldVisible = oldVisible;
        this.newVisible = newVisible;
        this.oldLocation = oldLocation;
        this.newLocation = newLocation;
        if (oldLocation == null && newLocation != null) {
            this.locationChanged = true;
        } else if (oldLocation != null && !oldLocation.equals(newLocation)) {
            this.locationChanged = true;
        }
    }

    public CDockable getDockable() {
        return this.dockable;
    }

    public boolean isLocationChanged() {
        return this.locationChanged;
    }

    public CLocation getOldLocation() {
        return this.oldLocation;
    }

    public CLocation getNewLocation() {
        return this.newLocation;
    }

    public boolean isVisibleChanged() {
        return this.oldVisible != this.newVisible;
    }

    public boolean getOldVisible() {
        return this.oldVisible;
    }

    public boolean getNewVisible() {
        return this.newVisible;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        if (this.isVisibleChanged()) {
            builder.append("VISIBILITY: ").append(this.oldVisible).append(" -> ").append(this.newVisible);
        }
        if (this.isLocationChanged()) {
            if (this.isVisibleChanged()) {
                builder.append(", ");
            }
            builder.append("LOCATION: ").append(this.oldLocation).append(" -> ").append(this.newLocation);
        }
        builder.append("]");
        return builder.toString();
    }
}

