/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropDownMenuHandler
implements MenuViewItem<JComponent> {
    private SimpleMenuAction menuAction;
    private MenuMenuHandler handler;
    private DropDownAction action;
    private Listener listener = new Listener();
    private Dockable dockable;
    private ActionListener menuListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DockAction child = (DockAction)e.getSource();
            DropDownViewItem item = (DropDownViewItem)DropDownMenuHandler.this.handler.getViewFor(child);
            if (item != null && item.isSelectable()) {
                DropDownMenuHandler.this.action.setSelection(DropDownMenuHandler.this.dockable, child);
            }
        }
    };

    public DropDownMenuHandler(DropDownAction action, Dockable dockable) {
        this.action = action;
        this.dockable = dockable;
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void removeActionListener(ActionListener listener) {
    }

    @Override
    public void bind() {
        this.action.bind(this.dockable);
        DockActionSource source = this.action.getSubActions(this.dockable);
        this.menuAction = new SimpleMenuAction(source);
        this.handler = new MenuMenuHandler(this.menuAction, this.dockable, (ViewTarget<? extends MenuViewItem<JComponent>>)ViewTarget.DROP_DOWN);
        this.menuAction.setText(this.action.getText(this.dockable));
        this.menuAction.setTooltip(this.action.getTooltipText(this.dockable));
        this.menuAction.setEnabled(this.action.isEnabled(this.dockable));
        this.menuAction.setDisabledIcon(this.action.getDisabledIcon(this.dockable));
        this.menuAction.setIcon(this.action.getIcon(this.dockable));
        this.handler.bind();
        this.handler.addChildrenActionListener(this.menuListener);
        this.action.addDockActionListener(this.listener);
    }

    @Override
    public void unbind() {
        this.handler.removeChildrenActionListener(this.menuListener);
        this.handler.unbind();
        this.action.removeDockActionListener(this.listener);
        this.action.unbind(this.dockable);
        this.menuAction = null;
        this.handler = null;
    }

    @Override
    public DockAction getAction() {
        return this.action;
    }

    @Override
    public JComponent getItem() {
        return this.handler.getItem();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setEnabled(action.isEnabled(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setIcon(action.getIcon(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setDisabledIcon(action.getDisabledIcon(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setText(action.getText(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(DropDownMenuHandler.this.dockable)) {
                DropDownMenuHandler.this.menuAction.setTooltip(action.getTooltipText(DropDownMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(dockables)) {
                DropDownMenuHandler.this.menuAction.setDockableRepresentation(action.getDockableRepresentation(DropDownMenuHandler.this.dockable));
            }
        }
    }
}

