/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.facile.action.KeyedActionSource;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.Mode;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedLocationModeActionProvider
extends DefaultLocationModeActionProvider {
    private String key;
    private List<KeyedActionSource> sources = new LinkedList<KeyedActionSource>();

    public KeyedLocationModeActionProvider(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.key = key;
    }

    public KeyedLocationModeActionProvider(String key, CAction defaultAction) {
        this(key);
        this.setSelectModeAction(defaultAction);
    }

    public KeyedLocationModeActionProvider(String key, DockAction defaultAction) {
        this(key);
        this.setSelectModeAction(defaultAction);
    }

    @Override
    public void setSelectModeAction(DockAction selectModeAction) {
        super.setSelectModeAction(selectModeAction);
        for (KeyedActionSource source : this.sources) {
            source.setDefaultAction(selectModeAction);
        }
    }

    @Override
    public DockActionSource getActions(Dockable dockable, Mode<Location> currentMode, DockActionSource currentSource) {
        if (currentSource instanceof KeyedActionSource && ((KeyedActionSource)currentSource).getKey().equals(this.key)) {
            return currentSource;
        }
        if (dockable instanceof CommonDockable) {
            CDockable cdockable = ((CommonDockable)dockable).getDockable();
            KeyedActionSource source = new KeyedActionSource(cdockable, this.key);
            this.sources.add(source);
            source.setDefaultAction(this.getSelectModeAction());
            source.setVisible(true);
            return source;
        }
        return super.getActions(dockable, currentMode, currentSource);
    }

    @Override
    public void destroy(Dockable dockable, DockActionSource source) {
        if (this.sources.remove(source)) {
            ((KeyedActionSource)source).destroy();
        }
    }
}

