% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spsga}
\alias{spsga}
\title{Savitzky-Golay Smoothing Filter of a Mid-infrared Spectrum}
\usage{
spsga(spectrum, p = 2, sw = 21)
}
\arguments{
\item{spectrum}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the second row corresponds to absorbances.}

\item{p}{numeric. Filter order. Defaults to 2.}

\item{sw}{numeric. Filter length (must be odd). Defaults to 21.}
}
\value{
A smoothed spectrum matrix by means of a Savitzky-Golay smoothing filter. The first row corresponds to wavenumber; the second row corresponds to absorbances.
}
\description{
This function allows applying a Savitzky-Golay smoothing filter to the mid-infrared spectrum (N spectra= 1).
}
\examples{
data(spData)
# Convert data frame to matrix
spectrum <- as.matrix(t(spData[, c("Wavenumber","A")]))
# Smoothed spectrum
sga <- spsga(spectrum=spectrum, p=2, sw= 21)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

