% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cir_gaps}
\alias{cir_gaps}
\title{Circular gaps}
\usage{
cir_gaps(Theta, sorted = FALSE)
}
\arguments{
\item{Theta}{a \bold{matrix} of size \code{c(n, M)} with \code{M} samples
of size \code{n} of circular data on \eqn{[0, 2\pi)}. Must not contain
\code{NA}'s.}

\item{sorted}{are the columns of \code{Theta} sorted increasingly? If
\code{TRUE}, performance is improved. If \code{FALSE} (default), each
column of \code{Theta} is sorted internally.}
}
\value{
A matrix of size \code{c(n, M)} containing the \code{n} circular
gaps for each of the \code{M} circular samples.
}
\description{
Computation of the circular gaps of an angular sample
\eqn{\Theta_1,\ldots,\Theta_n} on \eqn{[0, 2\pi)}, defined as
\deqn{\Theta_{(2)} - \Theta_{(1)},\ldots,\Theta_{(n)} - \Theta_{(n - 1)},
2\pi - \Theta_{(n)} - \Theta_{(1)},}
where
\deqn{0 \le \Theta_{(1)} \le \Theta_{(2)} \le \ldots \le
\Theta_{(n)} \le 2\pi.}
}
\section{Warning}{

Be careful on avoiding the next bad usages of \code{cir_gaps}, which will
produce spurious results:
\itemize{
  \item The entries of \code{Theta} are \emph{not} in \eqn{[0, 2\pi)}.
  \item \code{Theta} is \emph{not} sorted increasingly when
  \code{data_sorted = TRUE}.
}
}

\examples{
Theta <- cbind(c(pi, 0, 3 * pi / 2), c(0, 3 * pi / 2, pi), c(5, 3, 1))
cir_gaps(Theta)
}
