% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{render_gganimate}
\alias{render_gganimate}
\title{Render the slides as a \emph{gganimate} animation.}
\usage{
render_gganimate(
  fps = 3L,
  rewind = FALSE,
  start_pause = 1L,
  end_pause = 3L,
  gif_filename = NULL,
  gif_path = NULL,
  ...
)
}
\arguments{
\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{rewind}{Logical, should the animation play backwards after reaching
the end? Default to FALSE.}

\item{start_pause}{Number of seconds to pause on the first frame for.
Defaults to 1.}

\item{end_pause}{Number of seconds to pause on the last frame for.
Defaults to 3.}

\item{gif_filename}{Optional, saves the animation as a GIF to this string
(without folderpath) . Defaults to NULL (no GIF saved). For more control call
\code{gganimate::anim_save()} on a return object of \code{render_gganimate()}.}

\item{gif_path}{Optional, A string of the directory path (without filename)
to save a GIF to. Defaults to NULL (current work directory).}

\item{...}{Optionally passes arguments to the projection points inside the
aesthetics; \code{geom_point(aes(...))}.}
}
\description{
Takes the result of \code{array2df()} and renders them into a
\emph{gganimate} animation.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])
flea_class <- tourr::flea$species
rb <- tourr::basis_random(n = ncol(flea_std))
mtour <- manual_tour(basis = rb, manip_var = 4)
sshow <- array2df(array = mtour, data = flea_std)
\dontrun{
render_gganimate(slides = sshow)

render_gganimate(slides = sshow, axes = "bottomleft", fps = 2, rewind = TRUE,
  col = flea_class, pch = flea_class, size = 2, alpha = .6)
  
if(F){
  render_gganimate(slides = sshow, axes = "right", fps = 4, rewind = TRUE,
    col = flea_class, pch = flea_class, size = 2,
    gif_filename = "myRadialTour.gif", gif_path = "./docs")
}
}
}
